/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.bedrock;

import com.tacz.guns.client.model.bedrock.BedrockCube;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class BedrockPart {
    @Nullable
    public final String name;
    public final ObjectList<BedrockCube> cubes = new ObjectArrayList();
    public final ObjectList<BedrockPart> children = new ObjectArrayList();
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public boolean visible = true;
    public boolean illuminated = false;
    public boolean mirror;
    public Quaternionf additionalQuaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;
    protected BedrockPart parent;
    private float initRotX;
    private float initRotY;
    private float initRotZ;

    public BedrockPart(@Nullable String name) {
        this.name = name;
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void render(class_4587 matrixStack, class_811 transformType, class_4588 consumer, int light, int overlay) {
        this.render(matrixStack, transformType, consumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(class_4587 matrixStack, class_811 transformType, class_4588 consumer, int light, int overlay, float red, float green, float blue, float alpha) {
        int cubePackedLight = light;
        if (this.illuminated) {
            cubePackedLight = class_765.method_23687((int)15, (int)15);
        }
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            matrixStack.method_22903();
            this.translateAndRotateAndScale(matrixStack);
            this.compile(matrixStack.method_23760(), consumer, cubePackedLight, overlay, red, green, blue, alpha);
            for (BedrockPart part : this.children) {
                part.render(matrixStack, transformType, consumer, cubePackedLight, overlay, red, green, blue, alpha);
            }
            matrixStack.method_22909();
        }
    }

    public void translateAndRotateAndScale(class_4587 matrixStack) {
        matrixStack.method_46416(this.offsetX, this.offsetY, this.offsetZ);
        matrixStack.method_46416(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.zRot != 0.0f) {
            matrixStack.method_22907(class_7833.field_40718.rotation(this.zRot));
        }
        if (this.yRot != 0.0f) {
            matrixStack.method_22907(class_7833.field_40716.rotation(this.yRot));
        }
        if (this.xRot != 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotation(this.xRot));
        }
        matrixStack.method_22907(this.additionalQuaternion);
        matrixStack.method_22905(this.xScale, this.yScale, this.zScale);
    }

    public void compile(class_4587.class_4665 entry, class_4588 consumer, int light, int overlay, float red, float green, float blue, float alpha) {
        for (BedrockCube bedrockCube : this.cubes) {
            bedrockCube.compile(entry, consumer, light, overlay, red, green, blue, alpha);
        }
    }

    public BedrockCube getRandomCube(Random random) {
        return (BedrockCube)this.cubes.get(random.nextInt(this.cubes.size()));
    }

    public boolean isEmpty() {
        return this.cubes.isEmpty();
    }

    public void setInitRotationAngle(float x, float y, float z) {
        this.initRotX = x;
        this.initRotY = y;
        this.initRotZ = z;
    }

    public float getInitRotX() {
        return this.initRotX;
    }

    public float getInitRotY() {
        return this.initRotY;
    }

    public float getInitRotZ() {
        return this.initRotZ;
    }

    public void addChild(BedrockPart model) {
        this.children.add((Object)model);
    }

    public BedrockPart getParent() {
        return this.parent;
    }
}

