/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.LogicalSide;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.packets.c2s.PlayerReloadGunC2SPacket;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.util.AttachmentDataUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_746;

public class LocalPlayerReload {
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerReload(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void reload() {
        class_1799 mainhandItem = this.player.method_6047();
        class_1792 class_17922 = mainhandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            if (this.data.clientStateLock) {
                return;
            }
            if (IGunOperator.fromLivingEntity((class_1309)this.player).needCheckAmmo() && !this.inventoryHasAmmo(iGun, (ClientGunIndex)gunIndex, mainhandItem)) {
                return;
            }
            this.data.lockState(operator -> operator.getSynReloadState().getStateType().isReloading());
            if (new GunReloadEvent((class_1309)this.player, this.player.method_6047(), LogicalSide.CLIENT).post()) {
                return;
            }
            NetworkHandler.sendToServer(new PlayerReloadGunC2SPacket());
            this.doReload(iGun, (ClientGunIndex)gunIndex, mainhandItem);
        });
    }

    private void doReload(IGun iGun, ClientGunIndex gunIndex, class_1799 mainhandItem) {
        GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
        if (animationStateMachine != null) {
            Bolt boltType = gunIndex.getGunData().getBolt();
            boolean noAmmo = boltType == Bolt.OPEN_BOLT ? iGun.getCurrentAmmoCount(mainhandItem) <= 0 : !iGun.hasBulletInBarrel(mainhandItem);
            SoundPlayManager.stopPlayGunSound();
            SoundPlayManager.playReloadSound((class_1309)this.player, gunIndex, noAmmo);
            animationStateMachine.setNoAmmo(noAmmo).onGunReload();
        }
    }

    private void playMagExtendedAnimation(class_1799 mainhandItem, IGun iGun, GunAnimationStateMachine animationStateMachine) {
        class_2960 extendedMagId = iGun.getAttachmentId(mainhandItem, AttachmentType.EXTENDED_MAG);
        if (!DefaultAssets.isEmptyAttachmentId(extendedMagId)) {
            TimelessAPI.getCommonAttachmentIndex(extendedMagId).ifPresent(index -> animationStateMachine.setMagExtended(index.getData().getExtendedMagLevel() > 0));
        }
    }

    private boolean inventoryHasAmmo(IGun iGun, ClientGunIndex gunIndex, class_1799 mainhandItem) {
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(mainhandItem, gunIndex.getGunData());
        if (iGun.getCurrentAmmoCount(mainhandItem) >= maxAmmoCount) {
            return false;
        }
        if (iGun.useDummyAmmo(mainhandItem)) {
            return iGun.getDummyAmmoAmount(mainhandItem) > 0;
        }
        class_1661 inventory = this.player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            IAmmoBox iAmmoBox;
            IAmmo iAmmo;
            class_1799 checkAmmo = inventory.method_5438(i);
            class_1792 class_17922 = checkAmmo.method_7909();
            if (class_17922 instanceof IAmmo && (iAmmo = (IAmmo)class_17922).isAmmoOfGun(mainhandItem, checkAmmo)) {
                return true;
            }
            class_17922 = checkAmmo.method_7909();
            if (!(class_17922 instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)class_17922).isAmmoBoxOfGun(mainhandItem, checkAmmo)) continue;
            return true;
        }
        return false;
    }
}

