/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.packets.c2s.PlayerAimC2SPacket;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_746;

public class LocalPlayerAim {
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerAim(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void aim(boolean isAim) {
        class_1799 mainhandItem = this.player.method_6047();
        class_1792 class_17922 = mainhandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            this.data.clientIsAiming = isAim;
            NetworkHandler.sendToServer(new PlayerAimC2SPacket(isAim));
        });
    }

    public float getClientAimingProgress(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)LocalPlayerDataHolder.oldAimingProgress, (float)this.data.clientAimingProgress);
    }

    public boolean isAim() {
        return this.data.clientIsAiming;
    }

    public boolean cancelSprint(class_746 player, boolean pSprinting) {
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)player);
        boolean isAiming = gunOperator.getSynIsAiming();
        ReloadState.StateType reloadStateType = gunOperator.getSynReloadState().getStateType();
        if (isAiming || reloadStateType.isReloading() && !reloadStateType.isReloadFinishing()) {
            return false;
        }
        return pSprinting;
    }

    public void tickAimingProgress() {
        class_1799 mainhandItem = this.player.method_6047();
        class_1792 class_17922 = mainhandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            this.data.clientAimingProgress = 0.0f;
            LocalPlayerDataHolder.oldAimingProgress = 0.0f;
            return;
        }
        IGun iGun = (IGun)class_17922;
        if (System.currentTimeMillis() - this.data.clientDrawTimestamp < 0L) {
            this.data.clientIsAiming = false;
        }
        class_2960 gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresentOrElse(index -> {
            float alphaProgress = this.getAlphaProgress(index.getGunData(), mainhandItem);
            this.aimProgressCalculate(alphaProgress);
        }, () -> {
            this.data.clientAimingProgress = 0.0f;
            LocalPlayerDataHolder.oldAimingProgress = 0.0f;
        });
    }

    private void aimProgressCalculate(float alphaProgress) {
        LocalPlayerDataHolder.oldAimingProgress = this.data.clientAimingProgress;
        if (this.data.clientIsAiming) {
            this.data.clientAimingProgress += alphaProgress;
            if (this.data.clientAimingProgress > 1.0f) {
                this.data.clientAimingProgress = 1.0f;
            }
        } else {
            this.data.clientAimingProgress -= alphaProgress;
            if (this.data.clientAimingProgress < 0.0f) {
                this.data.clientAimingProgress = 0.0f;
            }
        }
        this.data.clientAimingTimestamp = System.currentTimeMillis();
    }

    private float getAlphaProgress(GunData gunData, class_1799 mainhandItem) {
        float[] aimTime = new float[]{gunData.getAimTime()};
        AttachmentDataUtils.getAllAttachmentData(mainhandItem, gunData, attachmentData -> {
            aimTime[0] = aimTime[0] + attachmentData.getAdsAddendTime();
        });
        aimTime[0] = Math.max(0.0f, aimTime[0]);
        return (float)(System.currentTimeMillis() - this.data.clientAimingTimestamp + 1L) / (aimTime[0] * 1000.0f);
    }
}

