/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.LogicalSide;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.event.RenderHandEvent;
import com.tacz.guns.api.client.event.RenderItemInHandBobEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.screen.RefitTransform;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.functional.MuzzleFlashRender;
import com.tacz.guns.client.model.functional.ShellRender;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.util.math.Easing;
import com.tacz.guns.util.math.MathUtil;
import com.tacz.guns.util.math.PerlinNoise;
import com.tacz.guns.util.math.SecondOrderDynamics;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FirstPersonRenderGunEvent {
    private static final SecondOrderDynamics AIMING_DYNAMICS = new SecondOrderDynamics(1.2f, 1.2f, 0.5f, 0.0f);
    private static final SecondOrderDynamics REFIT_OPENING_DYNAMICS = new SecondOrderDynamics(1.0f, 1.2f, 0.5f, 0.0f);
    private static final SecondOrderDynamics JUMPING_DYNAMICS = new SecondOrderDynamics(0.28f, 1.0f, 0.65f, 0.0f);
    private static final float JUMPING_Y_SWAY = -2.0f;
    private static final float JUMPING_SWAY_TIME = 0.3f;
    private static final float LANDING_SWAY_TIME = 0.15f;
    private static final PerlinNoise SHOOT_X_SWAY_NOISE = new PerlinNoise(-0.2f, 0.2f, 400L);
    private static final PerlinNoise SHOOT_Y_ROTATION_NOISE = new PerlinNoise(-0.0136f, 0.0136f, 100L);
    private static final float SHOOT_Y_SWAY = -0.1f;
    private static final float SHOOT_ANIMATION_TIME = 0.3f;
    private static float jumpingSwayProgress = 0.0f;
    private static boolean lastOnGround = false;
    private static long jumpingTimeStamp = -1L;
    private static long shootTimeStamp = -1L;

    public static void onRenderHand(RenderHandEvent event) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (event.getHand() == class_1268.field_5810) {
            class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            if (stack.method_7909() instanceof IGun) {
                event.setCanceled(true);
            }
            return;
        }
        class_1799 stack = event.getItemStack();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_811 transformType = event.getHand() == class_1268.field_5808 ? class_811.field_4322 : class_811.field_4321;
        class_2960 gunId = iGun.getGunId(stack);
        TimelessAPI.getClientGunIndex(gunId).ifPresentOrElse(gunIndex -> {
            BedrockGunModel gunModel = gunIndex.getGunModel();
            GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
            if (gunModel == null) {
                return;
            }
            if (animationStateMachine != null) {
                animationStateMachine.update(event.getPartialTick(), (class_1297)player);
            }
            class_4587 poseStack = event.getPoseStack();
            poseStack.method_22903();
            float xRotOffset = class_3532.method_16439((float)event.getPartialTick(), (float)player.field_3914, (float)player.field_3916);
            float yRotOffset = class_3532.method_16439((float)event.getPartialTick(), (float)player.field_3931, (float)player.field_3932);
            float xRot = player.method_5695(event.getPartialTick()) - xRotOffset;
            float yRot = player.method_5705(event.getPartialTick()) - yRotOffset;
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(xRot * -0.1f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(yRot * -0.1f));
            BedrockPart rootNode = gunModel.getRootNode();
            if (rootNode != null) {
                xRot = (float)Math.tanh(xRot / 25.0f) * 25.0f;
                yRot = (float)Math.tanh(yRot / 25.0f) * 25.0f;
                rootNode.offsetX += yRot * 0.1f / 16.0f / 3.0f;
                rootNode.offsetY += -xRot * 0.1f / 16.0f / 3.0f;
                rootNode.additionalQuaternion.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(xRot * 0.05f));
                rootNode.additionalQuaternion.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(yRot * 0.05f));
            }
            poseStack.method_46416(0.0f, 1.5f, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            FirstPersonRenderGunEvent.applyFirstPersonGunTransform(player, stack, gunIndex, poseStack, gunModel, event.getPartialTick());
            MuzzleFlashRender.isSelf = true;
            ShellRender.isSelf = true;
            boolean renderHand = gunModel.getRenderHand();
            if (RefitTransform.getOpeningProgress() != 0.0f) {
                gunModel.setRenderHand(false);
            }
            class_1921 renderType = class_1921.method_23576((class_2960)gunIndex.getModelTexture());
            gunModel.render(poseStack, stack, transformType, renderType, event.getPackedLight(), class_4608.field_21444);
            FirstPersonRenderGunEvent.renderBulletTracer(player, poseStack, gunModel, event.getPartialTick());
            gunModel.setRenderHand(renderHand);
            poseStack.method_22909();
            gunModel.cleanAnimationTransform();
            MuzzleFlashRender.isSelf = false;
            ShellRender.isSelf = false;
            event.setCanceled(true);
        }, () -> FirstPersonRenderGunEvent.renderBulletTracer(player, event.getPoseStack(), null, event.getPartialTick()));
    }

    private static void renderBulletTracer(class_746 player, class_4587 poseStack, BedrockGunModel gunModel, float partialTicks) {
        if (!((Boolean)RenderConfig.FIRST_PERSON_BULLET_TRACER_ENABLE.get()).booleanValue()) {
            return;
        }
        Optional<BedrockModel> modelOptional = InternalAssetLoader.getBedrockModel(InternalAssetLoader.DEFAULT_BULLET_MODEL);
        if (modelOptional.isEmpty()) {
            return;
        }
        BedrockModel model = modelOptional.get();
        class_1937 level = player.method_37908();
        class_238 renderArea = player.method_5829().method_1009(256.0, 256.0, 256.0);
        for (class_1297 entity : level.method_8333((class_1297)player, renderArea, FirstPersonRenderGunEvent::bulletFromPlayer)) {
            EntityKineticBullet entityBullet = (EntityKineticBullet)entity;
            if (!entityBullet.isTracerAmmo()) continue;
            class_243 deltaMovement = entityBullet.method_18798().method_18805((double)partialTicks, (double)partialTicks, (double)partialTicks);
            class_243 entityPosition = entityBullet.method_30950(0.0f).method_1019(deltaMovement);
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            class_243 cameraPosition = camera.method_19326();
            class_243 originCameraPosition = entityBullet.getOriginCameraPosition();
            if (originCameraPosition == null) {
                if (gunModel == null || gunModel.getMuzzleFlashPosPath() == null) continue;
                poseStack.method_22903();
                for (BedrockPart bedrockPart : gunModel.getMuzzleFlashPosPath()) {
                    bedrockPart.translateAndRotateAndScale(poseStack);
                }
                Matrix4f pose = poseStack.method_23760().method_23761();
                originCameraPosition = new class_243(cameraPosition.field_1352, cameraPosition.field_1351, cameraPosition.field_1350);
                entityBullet.setOriginCameraPosition(originCameraPosition);
                entityBullet.setOriginRenderOffset(new class_243((double)pose.m30(), (double)pose.m31(), (double)pose.m32()));
                poseStack.method_22909();
            }
            class_243 originRenderOffset = entityBullet.getOriginRenderOffset();
            class_243 alphaCameraTranslation = originCameraPosition.method_1020(cameraPosition);
            double distance = entityPosition.method_1022(originCameraPosition);
            class_243 bulletDirection = entityPosition.method_1020(originCameraPosition);
            double yRot = MathUtil.getTwoVecAngle(new class_243(0.0, 0.0, -1.0), new class_243(bulletDirection.field_1352, 0.0, bulletDirection.field_1350));
            double xRot = MathUtil.getTwoVecAngle(new class_243(bulletDirection.field_1352, 0.0, bulletDirection.field_1350), bulletDirection);
            if (yRot == -1.0) {
                yRot = Math.toRadians(camera.method_19330() + 180.0f);
            }
            if (xRot == -1.0) {
                xRot = Math.toRadians(camera.method_19329());
            }
            xRot *= bulletDirection.field_1351 > 0.0 ? -1.0 : 1.0;
            double d = bulletDirection.field_1352 > 0.0 ? 1.0 : -1.0;
            class_4587 poseStack1 = new class_4587();
            poseStack1.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
            poseStack1.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
            poseStack1.method_22904(alphaCameraTranslation.field_1352, alphaCameraTranslation.field_1351, alphaCameraTranslation.field_1350);
            poseStack1.method_22907(class_7833.field_40715.rotation((float)(yRot *= d)));
            poseStack1.method_22907(class_7833.field_40713.rotation((float)xRot));
            poseStack1.method_22904(originRenderOffset.field_1352, originRenderOffset.field_1351, originRenderOffset.field_1350 - distance);
            float trailLength = 0.5f * (float)entityBullet.method_18798().method_1033();
            poseStack1.method_46416(0.0f, 0.0f, -trailLength / 2.0f);
            poseStack1.method_22905(0.03f, 0.03f, trailLength);
            class_2960 gunId = entityBullet.getGunId();
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                float[] gunTracerColor = gunIndex.getTracerColor();
                if (gunTracerColor == null) {
                    class_2960 ammoId = entityBullet.getAmmoId();
                    TimelessAPI.getClientAmmoIndex(ammoId).ifPresent(ammoIndex -> {
                        float[] ammoTracerColor = ammoIndex.getTracerColor();
                        class_1921 type = class_1921.method_23018((class_2960)InternalAssetLoader.DEFAULT_BULLET_TEXTURE, (float)15.0f, (float)15.0f);
                        model.render(poseStack1, class_811.field_4315, type, class_765.method_23687((int)15, (int)15), class_4608.field_21444, ammoTracerColor[0], ammoTracerColor[1], ammoTracerColor[2], 1.0f);
                    });
                } else {
                    class_1921 type = class_1921.method_23018((class_2960)InternalAssetLoader.DEFAULT_BULLET_TEXTURE, (float)15.0f, (float)15.0f);
                    model.render(poseStack1, class_811.field_4315, type, class_765.method_23687((int)15, (int)15), class_4608.field_21444, gunTracerColor[0], gunTracerColor[1], gunTracerColor[2], 1.0f);
                }
            });
        }
    }

    public static void cancelItemInHandViewBobbing(RenderItemInHandBobEvent.BobView event) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        class_1799 itemStack = KeepingItemRenderer.getRenderer().getCurrentItem();
        if (IGun.getIGunOrNull(itemStack) != null) {
            event.setCanceled(true);
        }
    }

    public static void onGunFire(GunFireEvent event) {
        LogicalSide side = event.getLogicalSide();
        if (side.isClient()) {
            class_746 player;
            class_1309 shooter = event.getShooter();
            if (!shooter.equals((Object)(player = class_310.method_1551().field_1724))) {
                return;
            }
            class_1799 mainhandItem = player.method_6047();
            IGun iGun = IGun.getIGunOrNull(mainhandItem);
            if (iGun == null) {
                return;
            }
            TimelessAPI.getClientGunIndex(iGun.getGunId(mainhandItem)).ifPresent(gunIndex -> {
                shootTimeStamp = System.currentTimeMillis();
                MuzzleFlashRender.onShoot();
                if (gunIndex.getShellEjection() != null) {
                    ShellRender.addShell(gunIndex.getShellEjection().getRandomVelocity());
                }
            });
        }
    }

    private static boolean bulletFromPlayer(class_1297 entity) {
        if (entity instanceof EntityKineticBullet) {
            EntityKineticBullet entityBullet = (EntityKineticBullet)entity;
            return entityBullet.method_24921() instanceof class_746;
        }
        return false;
    }

    private static void applyFirstPersonGunTransform(class_746 player, class_1799 gunItemStack, ClientGunIndex ignoredGunIndex, class_4587 poseStack, BedrockGunModel model, float partialTicks) {
        float refitScreenOpeningProgress = REFIT_OPENING_DYNAMICS.update(RefitTransform.getOpeningProgress());
        float aimingProgress = AIMING_DYNAMICS.update(IClientPlayerGunOperator.fromLocalPlayer(player).getClientAimingProgress(partialTicks));
        FirstPersonRenderGunEvent.applyGunMovements(model, aimingProgress, partialTicks);
        FirstPersonRenderGunEvent.applyFirstPersonPositioningTransform(poseStack, model, gunItemStack, aimingProgress, refitScreenOpeningProgress);
        FirstPersonRenderGunEvent.applyAnimationConstraintTransform(poseStack, model, aimingProgress * (1.0f - refitScreenOpeningProgress));
    }

    private static void applyGunMovements(BedrockGunModel model, float aimingProgress, float partialTicks) {
        FirstPersonRenderGunEvent.applyShootSwayAndRotation(model, aimingProgress);
        FirstPersonRenderGunEvent.applyJumpingSway(model, partialTicks);
    }

    private static void applyFirstPersonPositioningTransform(class_4587 poseStack, BedrockGunModel model, class_1799 stack, float aimingProgress, float refitScreenOpeningProgress) {
        IGun iGun = IGun.getIGunOrNull(stack);
        if (iGun == null) {
            return;
        }
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.identity();
        List<BedrockPart> idleNodePath = model.getIdleSightPath();
        List<BedrockPart> aimingNodePath = null;
        class_2960 scopeId = iGun.getAttachmentId(stack, AttachmentType.SCOPE);
        if (DefaultAssets.isEmptyAttachmentId(scopeId)) {
            aimingNodePath = model.getIronSightPath();
        } else {
            List<BedrockPart> scopeNodePath = model.getScopePosPath();
            if (scopeNodePath != null) {
                BedrockAttachmentModel attachmentModel;
                aimingNodePath = new ArrayList<BedrockPart>(scopeNodePath);
                Optional<ClientAttachmentIndex> indexOptional = TimelessAPI.getClientAttachmentIndex(scopeId);
                if (indexOptional.isPresent() && (attachmentModel = indexOptional.get().getAttachmentModel()) != null && attachmentModel.getScopeViewPath() != null) {
                    aimingNodePath.addAll(attachmentModel.getScopeViewPath());
                }
            }
        }
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(idleNodePath), transformMatrix, 1.0f - refitScreenOpeningProgress);
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(aimingNodePath), transformMatrix, (1.0f - refitScreenOpeningProgress) * aimingProgress);
        float refitTransformProgress = (float)Easing.easeOutCubic(RefitTransform.getTransformProgress());
        AttachmentType oldType = RefitTransform.getOldTransformType();
        AttachmentType currentType = RefitTransform.getCurrentTransformType();
        List<BedrockPart> fromNode = model.getRefitAttachmentViewPath(oldType);
        List<BedrockPart> toNode = model.getRefitAttachmentViewPath(currentType);
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(fromNode), transformMatrix, refitScreenOpeningProgress);
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(toNode), transformMatrix, refitScreenOpeningProgress * refitTransformProgress);
        poseStack.method_46416(0.0f, 1.5f, 0.0f);
        poseStack.method_34425(transformMatrix);
        poseStack.method_46416(0.0f, -1.5f, 0.0f);
    }

    @NotNull
    private static Matrix4f getPositioningNodeInverse(List<BedrockPart> nodePath) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.identity();
        if (nodePath != null) {
            for (int i = nodePath.size() - 1; i >= 0; --i) {
                BedrockPart part = nodePath.get(i);
                matrix4f.rotate((Quaternionfc)class_7833.field_40713.rotation(part.xRot));
                matrix4f.rotate((Quaternionfc)class_7833.field_40715.rotation(part.yRot));
                matrix4f.rotate((Quaternionfc)class_7833.field_40717.rotation(part.zRot));
                if (part.getParent() != null) {
                    matrix4f.translate(-part.x / 16.0f, -part.y / 16.0f, -part.z / 16.0f);
                    continue;
                }
                matrix4f.translate(-part.x / 16.0f, 1.5f - part.y / 16.0f, -part.z / 16.0f);
            }
        }
        return matrix4f;
    }

    private static void applyShootSwayAndRotation(BedrockGunModel model, float aimingProgress) {
        BedrockPart rootNode = model.getRootNode();
        if (rootNode != null) {
            float progress = 1.0f - (float)(System.currentTimeMillis() - shootTimeStamp) / 300.0f;
            if (progress < 0.0f) {
                progress = 0.0f;
            }
            progress = (float)Easing.easeOutCubic(progress);
            rootNode.offsetX += SHOOT_X_SWAY_NOISE.getValue() / 16.0f * progress * (1.0f - aimingProgress);
            rootNode.offsetY += 0.00625f * progress * (1.0f - aimingProgress);
            rootNode.additionalQuaternion.mul((Quaternionfc)class_7833.field_40716.rotation(SHOOT_Y_ROTATION_NOISE.getValue() * progress));
        }
    }

    private static void applyJumpingSway(BedrockGunModel model, float partialTicks) {
        class_746 player;
        if (jumpingTimeStamp == -1L) {
            jumpingTimeStamp = System.currentTimeMillis();
        }
        if ((player = class_310.method_1551().field_1724) != null) {
            double posY = class_3532.method_16436((double)partialTicks, (double)class_310.method_1551().field_1724.field_5971, (double)class_310.method_1551().field_1724.method_23318());
            float velocityY = (float)(posY - class_310.method_1551().field_1724.field_5971) / partialTicks;
            if (player.method_24828()) {
                if (!lastOnGround) {
                    jumpingSwayProgress = velocityY / -0.1f;
                    if (jumpingSwayProgress > 1.0f) {
                        jumpingSwayProgress = 1.0f;
                    }
                    lastOnGround = true;
                } else if ((jumpingSwayProgress -= (float)(System.currentTimeMillis() - jumpingTimeStamp) / 150.0f) < 0.0f) {
                    jumpingSwayProgress = 0.0f;
                }
            } else if (lastOnGround) {
                jumpingSwayProgress = velocityY / 0.42f;
                if (jumpingSwayProgress > 1.0f) {
                    jumpingSwayProgress = 1.0f;
                }
                lastOnGround = false;
            } else if ((jumpingSwayProgress -= (float)(System.currentTimeMillis() - jumpingTimeStamp) / 300.0f) < 0.0f) {
                jumpingSwayProgress = 0.0f;
            }
        }
        jumpingTimeStamp = System.currentTimeMillis();
        float ySway = JUMPING_DYNAMICS.update(-2.0f * jumpingSwayProgress);
        BedrockPart rootNode = model.getRootNode();
        if (rootNode != null) {
            rootNode.offsetY += -ySway / 16.0f;
        }
    }

    private static void getAnimationConstraintTransform(List<BedrockPart> nodePath, @NotNull Vector3f originTranslation, @NotNull Vector3f animatedTranslation, @NotNull Vector3f rotation) {
        if (nodePath == null) {
            return;
        }
        Matrix4f animeMatrix = new Matrix4f();
        Matrix4f originMatrix = new Matrix4f();
        animeMatrix.identity();
        originMatrix.identity();
        BedrockPart constrainNode = nodePath.get(nodePath.size() - 1);
        for (BedrockPart part : nodePath) {
            if (part != constrainNode) {
                animeMatrix.translate(part.offsetX, part.offsetY, part.offsetZ);
            }
            if (part.getParent() != null) {
                animeMatrix.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
            } else {
                animeMatrix.translate(part.x / 16.0f, part.y / 16.0f - 1.5f, part.z / 16.0f);
            }
            if (part != constrainNode) {
                animeMatrix.rotate((Quaternionfc)part.additionalQuaternion);
            }
            animeMatrix.rotate((Quaternionfc)class_7833.field_40718.rotation(part.zRot));
            animeMatrix.rotate((Quaternionfc)class_7833.field_40716.rotation(part.yRot));
            animeMatrix.rotate((Quaternionfc)class_7833.field_40718.rotation(part.xRot));
            if (part.getParent() != null) {
                originMatrix.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
            } else {
                originMatrix.translate(part.x / 16.0f, part.y / 16.0f - 1.5f, part.z / 16.0f);
            }
            originMatrix.rotate((Quaternionfc)class_7833.field_40718.rotation(part.zRot));
            originMatrix.rotate((Quaternionfc)class_7833.field_40716.rotation(part.yRot));
            originMatrix.rotate((Quaternionfc)class_7833.field_40714.rotation(part.xRot));
        }
        animeMatrix.getTranslation(animatedTranslation);
        originMatrix.getTranslation(originTranslation);
        Vector3f animatedRotation = MathUtil.getEulerAngles(animeMatrix);
        Vector3f originRotation = MathUtil.getEulerAngles(originMatrix);
        animatedRotation.sub((Vector3fc)originRotation);
        rotation.set(animatedRotation.x(), animatedRotation.y(), animatedRotation.z());
    }

    public static void applyAnimationConstraintTransform(class_4587 poseStack, BedrockGunModel gunModel, float weight) {
        List<BedrockPart> nodePath = gunModel.getConstraintPath();
        if (nodePath == null) {
            return;
        }
        if (gunModel.getConstraintObject() == null) {
            return;
        }
        Vector3f originTranslation = new Vector3f();
        Vector3f animatedTranslation = new Vector3f();
        Vector3f rotation = new Vector3f();
        Vector3f translationICA = gunModel.getConstraintObject().translationConstraint;
        Vector3f rotationICA = gunModel.getConstraintObject().rotationConstraint;
        FirstPersonRenderGunEvent.getAnimationConstraintTransform(nodePath, originTranslation, animatedTranslation, rotation);
        Vector3f inverseTranslation = new Vector3f((Vector3fc)originTranslation);
        inverseTranslation.sub((Vector3fc)animatedTranslation);
        inverseTranslation.mul(1.0f - translationICA.x(), 1.0f - translationICA.y(), 1.0f - translationICA.z());
        Vector3f inverseRotation = new Vector3f((Vector3fc)rotation);
        inverseRotation.mul(rotationICA.x() - 1.0f, rotationICA.y() - 1.0f, rotationICA.z() - 1.0f);
        poseStack.method_46416(animatedTranslation.x(), animatedTranslation.y() + 1.5f, animatedTranslation.z());
        poseStack.method_22907(class_7833.field_40714.rotation(inverseRotation.x() * weight));
        poseStack.method_22907(class_7833.field_40716.rotation(inverseRotation.y() * weight));
        poseStack.method_22907(class_7833.field_40718.rotation(inverseRotation.z() * weight));
        poseStack.method_46416(-animatedTranslation.x(), -animatedTranslation.y() - 1.5f, -animatedTranslation.z());
        Matrix4f poseMatrix = poseStack.method_23760().method_23761();
        poseMatrix.m30(poseMatrix.m30() - inverseTranslation.x() * weight);
        poseMatrix.m31(poseMatrix.m31() - inverseTranslation.y() * weight);
        poseMatrix.m32(poseMatrix.m32() + inverseTranslation.z() * weight);
    }
}

