/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.tacz.guns.api.LogicalSide;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import com.tacz.guns.client.event.RenderCrosshairEvent;
import com.tacz.guns.client.gui.overlay.KillAmountOverlay;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.entity.TargetMinecart;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ClientHitMark {
    public static long lastHitTimestamp = 0L;
    public static float damageAmount = 0.0f;

    public static void onEntityHurtByGun(EntityHurtByGunEvent event) {
        LogicalSide logicalSide = event.getLogicalSide();
        if (logicalSide != LogicalSide.CLIENT) {
            return;
        }
        class_1309 attacker = event.getAttacker();
        class_746 player = class_310.method_1551().field_1724;
        class_1297 hurtEntity = event.getHurtEntity();
        if (player != null && player.equals((Object)attacker) && hurtEntity != null) {
            class_2960 gunId = event.getGunId();
            RenderCrosshairEvent.markHitTimestamp();
            if (event.isHeadShot()) {
                RenderCrosshairEvent.markHeadShotTimestamp();
                TimelessAPI.getClientGunIndex(gunId).ifPresent(index -> SoundPlayManager.playHeadHitSound((class_1309)player, index));
            } else {
                TimelessAPI.getClientGunIndex(gunId).ifPresent(index -> SoundPlayManager.playFleshHitSound((class_1309)player, index));
            }
            if (hurtEntity instanceof TargetMinecart) {
                damageAmount = System.currentTimeMillis() - lastHitTimestamp < (long)((Integer)RenderConfig.DAMAGE_COUNTER_RESET_TIME.get()).intValue() ? (damageAmount += event.getAmount()) : event.getAmount();
                float distance = player.method_5739(event.getHurtEntity());
                player.method_7353((class_2561)class_2561.method_43469((String)"message.tacz.target_minecart.hit", (Object[])new Object[]{String.format("%.1f", Float.valueOf(damageAmount)), String.format("%.2f", Float.valueOf(distance))}), true);
                lastHitTimestamp = System.currentTimeMillis();
            }
        }
    }

    public static void onEntityKillByGun(EntityKillByGunEvent event) {
        LogicalSide logicalSide = event.getLogicalSide();
        if (logicalSide != LogicalSide.CLIENT) {
            return;
        }
        class_1309 attacker = event.getAttacker();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.equals((Object)attacker)) {
            RenderCrosshairEvent.markKillTimestamp();
            KillAmountOverlay.markTimestamp();
            TimelessAPI.getClientGunIndex(event.getGunId()).ifPresent(index -> SoundPlayManager.playKillSound((class_1309)player, index));
            if (event.isHeadShot()) {
                RenderCrosshairEvent.markHeadShotTimestamp();
            }
        }
    }
}

