/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.generator;

import com.google.gson.JsonObject;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.GeneratorRecipeHelper;

public enum EFluidGenerator {
    THERMAL("TechReborn.ThermalGenerator", "thermal_generator"),
    GAS("TechReborn.GasGenerator", "gas_generator"),
    DIESEL("TechReborn.DieselGenerator", "diesel_generator"),
    SEMIFLUID("TechReborn.SemifluidGenerator", "semi_fluid_generator"),
    PLASMA("TechReborn.PlasmaGenerator", "plasma_generator");

    @NotNull
    private final String recipeID;
    private final class_2960 id;
    private final class_3956<FluidGeneratorRecipe> type;
    private final Serializer serializer;

    private EFluidGenerator(String recipeID, final String type) {
        this.recipeID = recipeID;
        this.id = class_2960.method_43902((String)"techreborn", (String)type);
        this.type = new class_3956<FluidGeneratorRecipe>(){

            public String toString() {
                return type;
            }
        };
        this.serializer = new Serializer(this);
    }

    public static void register() {
        for (EFluidGenerator generator : EFluidGenerator.values()) {
            class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)generator.id, generator.type);
            class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)generator.id, (Object)generator.serializer);
        }
    }

    @NotNull
    public String getRecipeID() {
        return this.recipeID;
    }

    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    public class_3956<FluidGeneratorRecipe> getType() {
        return this.type;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public static class Serializer
    implements class_1865<FluidGeneratorRecipe> {
        private final EFluidGenerator type;

        public Serializer(EFluidGenerator type) {
            this.type = type;
        }

        public FluidGeneratorRecipe read(class_2960 id, JsonObject json) {
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"fluid")));
            int power = class_3518.method_15260((JsonObject)json, (String)"power");
            FluidGeneratorRecipe recipe = new FluidGeneratorRecipe(fluid, power, this.type);
            GeneratorRecipeHelper.recipeIds.put(recipe, id);
            return recipe;
        }

        public FluidGeneratorRecipe read(class_2960 id, class_2540 buf) {
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10200(buf.readInt());
            int power = buf.readInt();
            FluidGeneratorRecipe recipe = new FluidGeneratorRecipe(fluid, power, this.type);
            GeneratorRecipeHelper.recipeIds.put(recipe, id);
            return recipe;
        }

        public void write(class_2540 buf, FluidGeneratorRecipe recipe) {
            buf.writeInt(class_7923.field_41173.method_10206((Object)recipe.fluid()));
            buf.writeInt(recipe.energyPerMb());
        }
    }
}

