/*
 * Decompiled with CFR 0.152.
 */
package techreborn;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3962;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.config.Configuration;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Torus;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.FluidGeneratorRecipeList;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.blockentity.GuiType;
import techreborn.config.TechRebornConfig;
import techreborn.events.ApplyArmorToDamageHandler;
import techreborn.events.OreDepthSyncHandler;
import techreborn.events.UseBlockHandler;
import techreborn.init.FuelRecipes;
import techreborn.init.ModLoot;
import techreborn.init.ModRecipes;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRCauldronBehavior;
import techreborn.init.TRContent;
import techreborn.init.TRDispenserBehavior;
import techreborn.init.template.TechRebornTemplates;
import techreborn.items.DynamicCellItem;
import techreborn.packets.ServerboundPackets;
import techreborn.utils.PoweredCraftingHandler;
import techreborn.world.WorldGenerator;

public class TechReborn
implements ModInitializer {
    public static final String MOD_ID = "techreborn";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"techreborn");

    public void onInitialize() {
        new Configuration(TechRebornConfig.class, MOD_ID);
        TRContent.register();
        ModRecipes.GRINDER.hashCode();
        TRContent.SCRAP_BOX.method_8389();
        ServerboundPackets.init();
        OreDepthSyncHandler.setup();
        if (TechRebornConfig.machineSoundVolume > 0.0f) {
            if (TechRebornConfig.machineSoundVolume > 1.0f) {
                TechRebornConfig.machineSoundVolume = 1.0f;
            }
            RecipeCrafter.soundHandler = new ModSounds.SoundHandler();
        }
        ModLoot.init();
        WorldGenerator.initWorldGen();
        EFluidGenerator.register();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            for (EFluidGenerator generator : EFluidGenerator.values()) {
                FluidGeneratorRecipeList list = GeneratorRecipeHelper.fluidRecipes.computeIfAbsent(generator, g -> new FluidGeneratorRecipeList(new FluidGeneratorRecipe[0]));
                server.method_3772().method_17717(generator.getType()).values().forEach(list::addRecipe);
            }
        });
        TRBlockEntities.THERMAL_GEN.toString();
        GuiType.AESU.getIdentifier();
        TRDispenserBehavior.init();
        TRCauldronBehavior.init();
        PoweredCraftingHandler.setup();
        UseBlockHandler.init();
        ApplyArmorToDamageHandler.init();
        FuelRecipes.init();
        Torus.genSizeMap((int)TechRebornConfig.fusionControlComputerMaxCoilSize);
        RedstoneConfiguration.fluidStack = DynamicCellItem.getCellWithFluid((class_3611)class_3612.field_15908);
        RedstoneConfiguration.powerStack = new class_1799((class_1935)TRContent.RED_CELL_BATTERY);
        class_3962.field_17566.put((Object)TRContent.RUBBER_SAPLING.method_8389(), 0.3f);
        class_3962.field_17566.put((Object)TRContent.RUBBER_LEAVES.method_8389(), 0.3f);
        class_3962.field_17566.put((Object)TRContent.Parts.PLANTBALL.method_8389(), 1.0f);
        class_3962.field_17566.put((Object)TRContent.Parts.COMPRESSED_PLANTBALL.method_8389(), 1.0f);
        class_3962.field_17566.put((Object)TRContent.Dusts.SAW.method_8389(), 0.3f);
        class_3962.field_17566.put((Object)TRContent.SmallDusts.SAW.method_8389(), 0.1f);
        TechRebornTemplates.init();
        LOGGER.info("TechReborn setup done!");
    }
}

