/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts;

import com.yahoo.chirpycricket.mythicmounts.MythicMountsClientPackets;
import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.ClimbingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.FlyingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class MythicMountsServerPackets {
    public static final class_2960 FLY_CONTROL = new class_2960("mythicmounts", "fly_control");
    public static final class_2960 CLIMB_CONTROL = new class_2960("mythicmounts", "climb_control");
    public static final class_2960 REQUEST_BIOME_INFO = new class_2960("mythicmounts", "request_server_biomes");
    public static final class_2960 REQUEST_BREEDING_ITEMS = new class_2960("mythicmounts", "request_server_breeding_items");
    public static final class_2960 REQUEST_FOOD_ITEMS = new class_2960("mythicmounts", "request_server_food_items");
    public static final class_2960 REQUEST_TAMING_ITEMS = new class_2960("mythicmounts", "request_server_taming_items");
    public static final class_2960 REQUEST_STATS = new class_2960("mythicmounts", "request_server_mount_stats");

    public static void startFlying(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        server.execute(() -> {
            class_1297 entity = player.method_5854();
            if (entity instanceof FlyingMountEntity) {
                FlyingMountEntity flyingMount = (FlyingMountEntity)entity;
                flyingMount.setFlyingParams(true);
            }
        });
    }

    public static void startClimbing(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        server.execute(() -> {
            class_1297 entity = player.method_5854();
            if (entity instanceof ClimbingMountEntity) {
                ClimbingMountEntity climbingMount = (ClimbingMountEntity)entity;
                climbingMount.setIsClimbing(true);
            }
        });
    }

    public static void getBiomes(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        class_2540 buffer = PacketByteBufs.create();
        for (Entities.EntityKey key : Entities.EntityKey.values()) {
            String write = key.name() + ";";
            for (String biome : Settings.settings.get((Object)((Object)key)).spawnBiomes) {
                write = Settings.settings.get((Object)((Object)key)).spawnType.equals("village") ? write + biome + " (villages);" : write + biome + ";";
            }
            buffer.method_10814(write);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)MythicMountsClientPackets.BIOME_INFO, (class_2540)buffer);
    }

    public static void getFoods(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        class_2540 buffer = PacketByteBufs.create();
        for (Entities.EntityKey key : Entities.EntityKey.values()) {
            String write = key.name() + ";";
            for (class_1792 item : Settings.settings.get((Object)((Object)key)).foodItems) {
                write = write + item.toString() + ";";
            }
            buffer.method_10814(write);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)MythicMountsClientPackets.FOOD_ITEMS, (class_2540)buffer);
    }

    public static void getBreedingItems(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        class_2540 buffer = PacketByteBufs.create();
        for (Entities.EntityKey key : Entities.EntityKey.values()) {
            String write = key.name() + ";";
            for (class_1792 item : Settings.settings.get((Object)((Object)key)).breedingItems) {
                write = write + item.toString() + ";";
            }
            buffer.method_10814(write);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)MythicMountsClientPackets.BREEDING_ITEMS, (class_2540)buffer);
    }

    public static void getTamingItems(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        class_2540 buffer = PacketByteBufs.create();
        for (Entities.EntityKey key : Entities.EntityKey.values()) {
            String write = key.name() + ";";
            for (class_1792 item : Settings.settings.get((Object)((Object)key)).tamingItems) {
                write = write + item.toString() + ";";
            }
            buffer.method_10814(write);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)MythicMountsClientPackets.TAMING_ITEMS, (class_2540)buffer);
    }

    public static void getMountStats(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        class_2540 buffer = PacketByteBufs.create();
        for (Entities.EntityKey key : Entities.EntityKey.values()) {
            String write = key.name() + ";";
            for (String str : MountEntity.getStats(key)) {
                write = write + str + ";";
            }
            buffer.method_10814(write);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)MythicMountsClientPackets.STATS, (class_2540)buffer);
    }

    public static void registerPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FLY_CONTROL, MythicMountsServerPackets::startFlying);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CLIMB_CONTROL, MythicMountsServerPackets::startClimbing);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_BIOME_INFO, MythicMountsServerPackets::getBiomes);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_FOOD_ITEMS, MythicMountsServerPackets::getFoods);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_BREEDING_ITEMS, MythicMountsServerPackets::getBreedingItems);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_TAMING_ITEMS, MythicMountsServerPackets::getTamingItems);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_STATS, MythicMountsServerPackets::getMountStats);
    }
}

