/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.energy;

import com.google.common.primitives.Ints;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.energy.EnergyHost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3218;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class EnergyCache
extends NetworkCache<EnergyHost, EnergyCache> {
    private SimpleEnergyStorage energyStorage = null;

    public EnergyCache(class_3218 level, List<NetworkNode<EnergyHost, EnergyCache>> nodes) {
        super(level, nodes);
    }

    public long getAmount() {
        this.combine();
        return this.energyStorage.getAmount();
    }

    public long getCapacity() {
        this.combine();
        return this.energyStorage.getCapacity();
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        this.combine();
        return this.energyStorage.insert(maxAmount, transaction);
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        this.combine();
        return this.energyStorage.extract(maxAmount, transaction);
    }

    @Override
    protected void doCombine() {
        long energy = 0L;
        long maxEnergy = 0L;
        for (NetworkNode node : this.nodes) {
            EnergyHost host = (EnergyHost)node.getHost();
            energy += host.getEnergy();
            maxEnergy += host.getMaxEnergy();
        }
        this.energyStorage = new SimpleEnergyStorage(maxEnergy, Long.MAX_VALUE, Long.MAX_VALUE);
        this.energyStorage.amount = energy;
    }

    @Override
    protected void doSeparate() {
        if (Transaction.isOpen()) {
            throw new IllegalStateException("Can't separate a network when a transaction is open!");
        }
        this.nodes.sort(Comparator.comparingLong(node -> ((EnergyHost)node.getHost()).getMaxEnergy()));
        int remainingNodes = this.nodes.size();
        for (NetworkNode node2 : this.nodes) {
            EnergyHost host = (EnergyHost)node2.getHost();
            long nodeEnergy = Math.min(host.getMaxEnergy(), this.energyStorage.amount / (long)remainingNodes);
            host.setEnergy(nodeEnergy);
            this.energyStorage.amount -= nodeEnergy;
            --remainingNodes;
        }
        this.energyStorage = null;
    }

    @Override
    public void doTick() {
        this.combine();
        ArrayList<EnergyStorage> storages = new ArrayList<EnergyStorage>();
        for (NetworkNode node : this.nodes) {
            if (!((EnergyHost)node.getHost()).isTicking()) continue;
            ((EnergyHost)node.getHost()).addEnergyStorages(storages);
        }
        try (Transaction tx = Transaction.openOuter();){
            this.energyStorage.amount += EnergyCache.transferForTargets(EnergyStorage::extract, storages, this.energyStorage.capacity - this.energyStorage.amount, tx);
            this.energyStorage.amount -= EnergyCache.transferForTargets(EnergyStorage::insert, storages, this.energyStorage.amount, tx);
            tx.commit();
        }
    }

    public static long transferForTargets(TransferOperation operation, List<EnergyStorage> targets, long maxAmount, Transaction tx) {
        int intMaxAmount = Ints.saturatedCast((long)maxAmount);
        ArrayList<EnergyTarget> sortableTargets = new ArrayList<EnergyTarget>(targets.size());
        for (EnergyStorage energyStorage : targets) {
            sortableTargets.add(new EnergyTarget(energyStorage));
        }
        Collections.shuffle(sortableTargets);
        for (EnergyTarget energyTarget : sortableTargets) {
            Transaction simulation = tx.openNested();
            try {
                energyTarget.simulationResult = operation.transfer(energyTarget.target, intMaxAmount, (TransactionContext)simulation);
            }
            finally {
                if (simulation == null) continue;
                simulation.close();
            }
        }
        sortableTargets.sort(Comparator.comparingLong(t -> t.simulationResult));
        long transferredAmount = 0L;
        for (int i = 0; i < sortableTargets.size(); ++i) {
            EnergyTarget target = (EnergyTarget)sortableTargets.get(i);
            int remainingTargets = sortableTargets.size() - i;
            long remainingAmount = maxAmount - transferredAmount;
            int targetMaxAmount = Ints.saturatedCast((long)(remainingAmount / (long)remainingTargets));
            transferredAmount += operation.transfer(target.target, targetMaxAmount, (TransactionContext)tx);
        }
        return transferredAmount;
    }

    @Override
    public void appendDebugInfo(StringBuilder out) {
        super.appendDebugInfo(out);
        if (this.energyStorage == null) {
            out.append("no energy storage\n");
        } else {
            out.append("energy = ").append(this.energyStorage.amount).append("\n");
            out.append("max energy = ").append(this.energyStorage.capacity).append("\n");
        }
    }

    public static interface TransferOperation {
        public long transfer(EnergyStorage var1, long var2, TransactionContext var4);
    }

    private static class EnergyTarget {
        final EnergyStorage target;
        long simulationResult;

        EnergyTarget(EnergyStorage target) {
            this.target = target;
        }
    }
}

