/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.SerializationHelper;
import java.util.EnumSet;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class NodeHost {
    protected final PipeBlockEntity pipe;
    private final AttachedAttachment[] attachments = new AttachedAttachment[6];
    public byte pipeConnections = 0;
    public int inventoryConnections = 0;
    private boolean needsUpdate = true;

    protected NodeHost(PipeBlockEntity pipe) {
        this.pipe = pipe;
    }

    public class_1937 getLevel() {
        return this.pipe.method_10997();
    }

    public class_2338 getPos() {
        return this.pipe.method_11016();
    }

    @Nullable
    public final AttachedAttachment removeAttachment(class_2350 side) {
        AttachedAttachment attachment = this.attachments[side.method_10146()];
        if (attachment != null) {
            this.attachments[side.method_10146()] = null;
            this.update();
            return attachment;
        }
        return null;
    }

    public final void setAttachment(class_2350 side, AttachmentItem item, class_2487 data) {
        AttachedAttachment current = this.attachments[side.method_10146()];
        if (current != null && current.getItem() == item) {
            if (current.update(data)) {
                this.scheduleUpdate();
            }
        } else {
            this.attachments[side.method_10146()] = item.createAttached(this, data);
            this.scheduleUpdate();
        }
    }

    @Nullable
    public final AttachedAttachment getAttachment(class_2350 side) {
        return this.attachments[side.method_10146()];
    }

    public abstract boolean acceptsAttachment(AttachmentItem var1, class_1799 var2);

    public final boolean isTicking() {
        return ((class_3218)this.pipe.method_10997()).method_37118(this.pipe.method_11016());
    }

    public boolean canConnectTo(class_2350 connectionDirection, NodeHost adjacentHost) {
        return (this.pipe.connectionBlacklist & 1 << connectionDirection.method_10146()) == 0;
    }

    public final void setConnections(EnumSet<class_2350> connections) {
        this.pipeConnections = SerializationHelper.directionsToMask(connections);
        this.pipe.sync();
    }

    public void onConnectedTo(NodeHost other) {
    }

    public void onConnectionRejectedTo(class_2350 direction, NodeHost other) {
    }

    public abstract NetworkManager getManager();

    public void addSelf() {
        this.getManager().addNode((class_3218)this.pipe.method_10997(), this.pipe.method_11016(), this);
    }

    public void removeSelf() {
        this.getManager().removeNode((class_3218)this.pipe.method_10997(), this.pipe.method_11016(), this);
    }

    public final void refreshSelf() {
        this.getManager().refreshNode((class_3218)this.pipe.method_10997(), this.pipe.method_11016(), this);
    }

    @Nullable
    public abstract Object getApiInstance(BlockApiLookup<?, class_2350> var1, @Nullable class_2350 var2);

    @Nullable
    protected final <H extends NodeHost, C extends NetworkCache<H, C>> NetworkNode<H, C> findNode() {
        return this.getManager().findNode((class_3218)this.pipe.method_10997(), this.pipe.method_11016());
    }

    public final void separateNetwork() {
        @Nullable NetworkNode<H, C> node = this.findNode();
        if (node != null && node.getHost() == this) {
            ((NetworkCache)node.getNetworkCache()).separate();
        }
    }

    protected final void update() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.doUpdate();
        }
    }

    protected void doUpdate() {
    }

    public final void scheduleUpdate() {
        if (!this.needsUpdate) {
            this.needsUpdate = true;
            @Nullable NetworkNode<H, C> node = this.findNode();
            if (node != null) {
                ((NetworkCache)node.getNetworkCache()).scheduleHostUpdate(this);
            }
        }
    }

    public final boolean needsUpdate() {
        return this.needsUpdate;
    }

    public final PipeBlockEntity getPipe() {
        return this.pipe;
    }

    private boolean hasAttachments() {
        for (AttachedAttachment attachment : this.attachments) {
            if (attachment == null) continue;
            return true;
        }
        return false;
    }

    @MustBeInvokedByOverriders
    public void writeNbt(class_2487 tag) {
        if (this.hasAttachments()) {
            class_2499 attachmentTags = new class_2499();
            for (AttachedAttachment attachment : this.attachments) {
                class_2487 attachmentTag = new class_2487();
                if (attachment != null) {
                    class_2960 id = class_7923.field_41178.method_10221((Object)attachment.getItem());
                    attachmentTag.method_10582("#i", id.toString());
                    attachment.writeConfigTag(attachmentTag);
                }
                attachmentTags.add((Object)attachmentTag);
            }
            tag.method_10566("attachments", (class_2520)attachmentTags);
        }
    }

    @MustBeInvokedByOverriders
    public void readNbt(class_2487 tag) {
        if (tag.method_10573("attachments", 9)) {
            class_2499 attachmentTags = tag.method_10554("attachments", 10);
            for (int i = 0; i < this.attachments.length; ++i) {
                class_2487 attachmentTag;
                class_1792 item;
                this.attachments[i] = null;
                if (i >= attachmentTags.size() || !((item = (class_1792)class_7923.field_41178.method_10223(new class_2960((attachmentTag = attachmentTags.method_10602(i)).method_10558("#i")))) instanceof AttachmentItem)) continue;
                AttachmentItem attachmentItem = (AttachmentItem)item;
                this.attachments[i] = attachmentItem.createAttached(this, attachmentTag);
            }
        }
    }

    @MustBeInvokedByOverriders
    public void writeClientNbt(class_2487 tag) {
    }

    @MustBeInvokedByOverriders
    public void readClientNbt(class_2487 tag) {
    }

    public void clientTick() {
    }

    public void onRemoved() {
    }

    public void addDrops(List<class_1799> drops) {
        for (class_2350 side : class_2350.values()) {
            AttachedAttachment attachment = this.getAttachment(side);
            if (attachment == null) continue;
            drops.addAll(attachment.getDrops());
        }
    }
}

