/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.technici4n.moderndynamics.attachment.RenderedAttachment;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.pipe.PipeBlock;
import dev.technici4n.moderndynamics.util.MdId;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_7403;

public class PipeModelsProvider
implements class_2405 {
    private final FabricDataOutput dataOutput;

    public PipeModelsProvider(FabricDataOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        ArrayList futures = new ArrayList();
        BiConsumer<JsonElement, Path> saver = (obj, path) -> futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path));
        this.registerPipeModels(saver);
        this.registerAttachments(saver);
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private void registerPipeModels(BiConsumer<JsonElement, Path> saver) {
        for (PipeBlock pipe : MdBlocks.ALL_PIPES) {
            this.registerPipeModel(pipe, saver);
        }
    }

    private void registerPipeModel(PipeBlock pipe, BiConsumer<JsonElement, Path> saver) {
        Path baseFolder = this.dataOutput.method_45971().resolve("assets/%s/models/pipe/%s".formatted(this.dataOutput.getModId(), pipe.id));
        this.registerPipePart(baseFolder, pipe, "connector", saver);
        this.registerPipePart(baseFolder, pipe, "straight", saver);
    }

    private void registerPipePart(Path baseFolder, PipeBlock pipe, String kind, BiConsumer<JsonElement, Path> saver) {
        JsonObject obj = new JsonObject();
        obj.addProperty("parent", MdId.of("base/%s%s".formatted(kind, pipe.isTransparent() ? "_transparent" : "")).toString());
        JsonObject textures = new JsonObject();
        obj.add("textures", (JsonElement)textures);
        textures.addProperty("0", MdId.of("pipe/%s/%s".formatted(pipe.id, kind)).toString());
        saver.accept((JsonElement)obj, baseFolder.resolve(kind + ".json"));
    }

    private void registerAttachments(BiConsumer<JsonElement, Path> saver) {
        for (RenderedAttachment attachment : RenderedAttachment.getAllAttachments()) {
            this.registerAttachment(attachment, "attachment/" + attachment.id.toLowerCase(Locale.ROOT), saver);
        }
    }

    private void registerAttachment(RenderedAttachment attachment, String texture, BiConsumer<JsonElement, Path> saver) {
        JsonObject obj = new JsonObject();
        obj.addProperty("parent", MdId.of("base/connector_transparent").toString());
        JsonObject textures = new JsonObject();
        obj.add("textures", (JsonElement)textures);
        textures.addProperty("0", MdId.of(texture).toString());
        saver.accept((JsonElement)obj, this.dataOutput.method_45971().resolve("assets/%s/models/attachment/%s.json".formatted(this.dataOutput.getModId(), attachment.id)));
    }

    public String method_10321() {
        return "Pipe Models";
    }
}

