/*
 * Decompiled with CFR 0.152.
 */
package de.tobs.lamps.configs;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.tobs.lamps.Lamps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import net.minecraft.class_1657;

public class ModConfigs {
    private static JsonArray CAN_USE_ZEUS;

    public static boolean canBeZeus(class_1657 player) {
        for (int i = 0; i < CAN_USE_ZEUS.size(); ++i) {
            if (!Objects.equals(CAN_USE_ZEUS.get(i).getAsJsonObject().get("uuid").getAsString(), player.method_5845()) || !Objects.equals(CAN_USE_ZEUS.get(i).getAsJsonObject().get("name").getAsString(), player.method_5477().getString())) continue;
            return true;
        }
        return false;
    }

    private static void createDefaultConfig(File file) {
        JsonArray defaultConfig = new JsonArray();
        try (FileWriter writer = new FileWriter(file);){
            new Gson().toJson((JsonElement)defaultConfig, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addPlayer(String uuid, String name, boolean canUse) {
        JsonObject playerData = new JsonObject();
        playerData.addProperty("uuid", uuid);
        playerData.addProperty("name", name);
        if (!CAN_USE_ZEUS.contains((JsonElement)playerData) && canUse) {
            CAN_USE_ZEUS.add((JsonElement)playerData);
        } else if (!canUse) {
            CAN_USE_ZEUS.remove((JsonElement)playerData);
        }
        ModConfigs.saveConfig();
    }

    private static void saveConfig() {
        try (FileWriter writer = new FileWriter("can-be-zeus.json");){
            new Gson().toJson((JsonElement)CAN_USE_ZEUS, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerModConfigs() {
        Lamps.LOGGER.info("lamps: Load Configs");
        File configFile = new File("can-be-zeus.json");
        if (!configFile.exists()) {
            ModConfigs.createDefaultConfig(configFile);
        }
        try (FileReader reader = new FileReader("can-be-zeus.json");){
            CAN_USE_ZEUS = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

