/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.options;

import com.teamresourceful.resourcefulconfig.client.options.DoubleSlider;
import com.teamresourceful.resourcefulconfig.client.options.LongSlider;
import com.teamresourceful.resourcefulconfig.client.options.NumberInputBox;
import com.teamresourceful.resourcefulconfig.common.annotations.ByteRange;
import com.teamresourceful.resourcefulconfig.common.annotations.DoubleRange;
import com.teamresourceful.resourcefulconfig.common.annotations.FloatRange;
import com.teamresourceful.resourcefulconfig.common.annotations.IntRange;
import com.teamresourceful.resourcefulconfig.common.annotations.LongRange;
import com.teamresourceful.resourcefulconfig.common.annotations.ShortRange;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import it.unimi.dsi.fastutil.doubles.DoubleConsumer;
import it.unimi.dsi.fastutil.doubles.DoubleDoublePair;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.function.LongConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5676;

public final class Options {
    public static class_339 create(int x, int y, int width, ResourcefulConfigEntry entry) {
        if (entry.field().getType().isArray()) {
            class_4185 button = class_4185.method_46430((class_2561)class_5244.field_39678, widget -> {}).method_46434(x, y, width, 20).method_46431();
            button.field_22763 = false;
            return button;
        }
        return switch (entry.type()) {
            default -> throw new IncompatibleClassChangeError();
            case EntryType.BOOLEAN -> Options.createBoolean(x, y, width, 20, entry);
            case EntryType.BYTE, EntryType.SHORT, EntryType.INTEGER, EntryType.LONG -> Options.createInt(x, y, width, 20, entry);
            case EntryType.FLOAT, EntryType.DOUBLE -> Options.createFloat(x, y, width, 20, entry);
            case EntryType.STRING -> new class_5676(class_310.method_1551().field_1772, x, y, width, 20, entry);
            case EntryType.ENUM -> Options.createEnum(x, y, width, 20, entry);
        };
    }

    public static class_5676<Enum<?>> createEnum(int x, int y, int width, int height, ResourcefulConfigEntry entry) {
        if (entry.type() != EntryType.ENUM) {
            throw new IllegalArgumentException("Entry is not an enum!");
        }
        ?[] values = entry.field().getType().getEnumConstants();
        class_5676.class_5677 builder = class_5676.method_32606(value -> class_2561.method_43470((String)value.name()));
        builder.method_32624((Object[])((Enum[])values));
        builder.method_32619((Object)((Enum)ParsingUtils.getField(entry.field())));
        builder.method_32616();
        return builder.method_32617(x, y, width, height, class_5244.field_39003, (button, value) -> entry.setEnum((Enum<?>)value));
    }

    public static class_5676<Boolean> createBoolean(int x, int y, int width, int height, ResourcefulConfigEntry entry) {
        if (entry.type() != EntryType.BOOLEAN) {
            throw new IllegalArgumentException("Entry is not a boolean!");
        }
        class_5676.class_5677 builder = class_5676.method_32607((class_2561)class_5244.field_24332, (class_2561)class_5244.field_24333);
        builder.method_32619((Object)((Boolean)ParsingUtils.getField(entry.field())));
        builder.method_32616();
        return builder.method_32617(x, y, width, height, class_5244.field_39003, (button, value) -> entry.setBoolean((boolean)value));
    }

    public static class_339 createInt(int x, int y, int width, int height, ResourcefulConfigEntry entry) {
        if (entry.type() != EntryType.INTEGER && entry.type() != EntryType.BYTE && entry.type() != EntryType.SHORT && entry.type() != EntryType.LONG) {
            throw new IllegalArgumentException("Entry is not an integer!");
        }
        it.unimi.dsi.fastutil.longs.LongConsumer setter = value -> {
            switch (entry.type()) {
                case BYTE: {
                    entry.setByte((byte)value);
                    break;
                }
                case SHORT: {
                    entry.setShort((short)value);
                    break;
                }
                case INTEGER: {
                    entry.setInt((int)value);
                    break;
                }
                case LONG: {
                    entry.setLong(value);
                }
            }
        };
        LongLongPair range = Options.getMinMax(entry);
        if (range == null) {
            return new NumberInputBox(class_310.method_1551().field_1772, x, y, width, height, ParsingUtils.getField(entry.field()).toString(), false, (LongConsumer)setter, null);
        }
        Number number = (Number)ParsingUtils.getField(entry.field());
        return new LongSlider(x, y, width, height, (class_2561)class_2561.method_43470((String)entry.field().getName()), number.longValue(), range.firstLong(), range.secondLong(), (LongConsumer)setter);
    }

    public static class_339 createFloat(int x, int y, int width, int height, ResourcefulConfigEntry entry) {
        if (entry.type() != EntryType.FLOAT && entry.type() != EntryType.DOUBLE) {
            throw new IllegalArgumentException("Entry is not a float!");
        }
        DoubleConsumer setter = value -> {
            switch (entry.type()) {
                case FLOAT: {
                    entry.setFloat((float)value);
                    break;
                }
                case DOUBLE: {
                    entry.setDouble(value);
                }
            }
        };
        DoubleDoublePair range = Options.getFloatingMinMax(entry);
        if (range == null) {
            return new NumberInputBox(class_310.method_1551().field_1772, x, y, width, height, ParsingUtils.getField(entry.field()).toString(), true, null, (java.util.function.DoubleConsumer)setter);
        }
        Number number = (Number)ParsingUtils.getField(entry.field());
        return new DoubleSlider(x, y, width, height, (class_2561)class_2561.method_43470((String)entry.field().getName()), number.doubleValue(), range.firstDouble(), range.secondDouble(), (java.util.function.DoubleConsumer)setter);
    }

    private static DoubleDoublePair getFloatingMinMax(ResourcefulConfigEntry entry) {
        switch (entry.type()) {
            case DOUBLE: {
                DoubleRange range = entry.field().getAnnotation(DoubleRange.class);
                if (range == null) {
                    return null;
                }
                return DoubleDoublePair.of((double)range.min(), (double)range.max());
            }
            case FLOAT: {
                FloatRange range = entry.field().getAnnotation(FloatRange.class);
                if (range == null) {
                    return null;
                }
                return DoubleDoublePair.of((double)range.min(), (double)range.max());
            }
        }
        return null;
    }

    private static LongLongPair getMinMax(ResourcefulConfigEntry entry) {
        return switch (entry.type()) {
            case EntryType.BYTE -> {
                ByteRange range = entry.field().getAnnotation(ByteRange.class);
                if (range != null) {
                    yield LongLongPair.of((long)range.min(), (long)range.max());
                }
                yield null;
            }
            case EntryType.SHORT -> {
                ShortRange range = entry.field().getAnnotation(ShortRange.class);
                if (range != null) {
                    yield LongLongPair.of((long)range.min(), (long)range.max());
                }
                yield null;
            }
            case EntryType.INTEGER -> {
                IntRange range = entry.field().getAnnotation(IntRange.class);
                if (range != null) {
                    yield LongLongPair.of((long)range.min(), (long)range.max());
                }
                yield null;
            }
            case EntryType.LONG -> {
                LongRange range = entry.field().getAnnotation(LongRange.class);
                if (range != null) {
                    yield LongLongPair.of((long)range.min(), (long)range.max());
                }
                yield null;
            }
            default -> throw new IllegalArgumentException("Entry is not an integer!");
        };
    }
}

