/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.ClickableIngredientInternal;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.input.handlers.NullInputHandler;
import mezz.jei.gui.input.handlers.ProxyInputHandler;
import mezz.jei.gui.overlay.elements.IngredientElement;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class RecipeGuiLayouts {
    private final List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons = new ArrayList();
    @Nullable
    private IUserInputHandler cachedInputHandler = NullInputHandler.INSTANCE;

    public void updateLayout(ImmutableRect2i recipeLayoutsArea, int recipesPerPage) {
        if (this.recipeLayoutsWithButtons.isEmpty()) {
            return;
        }
        RecipeLayoutWithButtons<?> firstLayout = this.recipeLayoutsWithButtons.get(0);
        ImmutableRect2i layoutAreaWithBorder = new ImmutableRect2i(firstLayout.recipeLayout().getRectWithBorder());
        int recipeXOffset = this.getRecipeXOffset(layoutAreaWithBorder, recipeLayoutsArea);
        int recipeHeight = layoutAreaWithBorder.getHeight();
        int availableHeight = Math.max(recipeLayoutsArea.getHeight(), recipeHeight);
        int remainingHeight = availableHeight - recipesPerPage * recipeHeight;
        int recipeSpacing = remainingHeight / (recipesPerPage + 1);
        int spacingY = recipeHeight + recipeSpacing;
        int recipeYOffset = recipeLayoutsArea.getY() + recipeSpacing;
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.recipeLayout();
            class_768 rectWithBorder = recipeLayout.getRectWithBorder();
            class_768 rect = recipeLayout.getRect();
            recipeLayout.setPosition(recipeXOffset - rectWithBorder.method_3321() + rect.method_3321(), recipeYOffset - rectWithBorder.method_3322() + rect.method_3322());
            recipeYOffset += spacingY;
        }
        this.updateRecipeButtonPositions();
    }

    private void updateRecipeButtonPositions() {
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.recipeLayout();
            class_768 layoutArea = recipeLayout.getRect();
            GuiIconToggleButton button = recipeLayoutWithButtons.transferButton();
            class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
            buttonArea.method_35778(buttonArea.method_3321() + layoutArea.method_3321());
            buttonArea.method_35781(buttonArea.method_3322() + layoutArea.method_3322());
            button.updateBounds(buttonArea);
            button = recipeLayoutWithButtons.bookmarkButton();
            buttonArea = recipeLayout.getRecipeBookmarkButtonArea();
            buttonArea.method_35778(buttonArea.method_3321() + layoutArea.method_3321());
            buttonArea.method_35781(buttonArea.method_3322() + layoutArea.method_3322());
            button.updateBounds(buttonArea);
        }
    }

    private int getRecipeXOffset(ImmutableRect2i layoutRect, ImmutableRect2i layoutsArea) {
        if (this.recipeLayoutsWithButtons.isEmpty()) {
            return layoutsArea.getX();
        }
        int recipeWidth = layoutRect.getWidth();
        int recipeWidthWithButtons = this.recipeLayoutsWithButtons.get(0).totalWidth();
        int buttonSpace = recipeWidthWithButtons - recipeWidth;
        int availableArea = layoutsArea.getWidth();
        if (availableArea > recipeWidth + 2 * buttonSpace) {
            return layoutsArea.getX() + (layoutsArea.getWidth() - recipeWidth) / 2;
        }
        return layoutsArea.getX() + (layoutsArea.getWidth() - recipeWidthWithButtons) / 2;
    }

    public IUserInputHandler createInputHandler() {
        return new ProxyInputHandler(() -> {
            if (this.cachedInputHandler == null) {
                List<IUserInputHandler> handlers = this.recipeLayoutsWithButtons.stream().map(RecipeLayoutWithButtons::createUserInputHandler).toList();
                this.cachedInputHandler = new CombinedInputHandler("RecipeGuiLayouts", handlers);
            }
            return this.cachedInputHandler;
        });
    }

    public void tick(@Nullable class_1703 parentContainer) {
        class_746 player = class_310.method_1551().field_1724;
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            recipeLayoutWithButtons.tick(parentContainer, (class_1657)player);
        }
    }

    public void setRecipeLayoutsWithButtons(List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons) {
        this.recipeLayoutsWithButtons.clear();
        this.recipeLayoutsWithButtons.addAll(recipeLayoutsWithButtons);
        this.cachedInputHandler = null;
    }

    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.recipeLayoutsWithButtons.stream().map(RecipeLayoutWithButtons::recipeLayout).map(recipeLayout -> recipeLayout.getSlotUnderMouse(mouseX, mouseY)).flatMap(Optional::stream).map(RecipeGuiLayouts::getClickedIngredient).flatMap(Optional::stream);
    }

    private static Optional<IClickableIngredientInternal<?>> getClickedIngredient(RecipeSlotUnderMouse slotUnderMouse) {
        return slotUnderMouse.slot().getDisplayedIngredient().map(displayedIngredient -> {
            IngredientElement element = new IngredientElement(displayedIngredient);
            return new ClickableIngredientInternal(element, slotUnderMouse::isMouseOver, false, true);
        });
    }

    public boolean mouseDragged(double mouseX, double mouseY, class_3675.class_306 input, double dragX, double dragY) {
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.recipeLayout();
            if (!this.mouseDragged(recipeLayout, mouseX, mouseY, input, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    private <R> boolean mouseDragged(IRecipeLayoutDrawable<R> recipeLayout, double mouseX, double mouseY, class_3675.class_306 input, double dragX, double dragY) {
        if (recipeLayout.isMouseOver(mouseX, mouseY)) {
            IJeiInputHandler inputHandler = recipeLayout.getInputHandler();
            return inputHandler.handleMouseDragged(mouseX, mouseY, input, dragX, dragY);
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.recipeLayout();
            if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
            IJeiInputHandler inputHandler = recipeLayout.getInputHandler();
            inputHandler.handleMouseMoved(mouseX, mouseY);
        }
    }

    public Optional<IRecipeLayoutDrawable<?>> draw(class_332 guiGraphics, int mouseX, int mouseY) {
        IRecipeLayoutDrawable<?> hoveredLayout = null;
        class_310 minecraft = class_310.method_1551();
        float partialTicks = minecraft.method_1534();
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.recipeLayout();
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(guiGraphics, mouseX, mouseY);
            RecipeTransferButton transferButton = recipeLayoutWithButtons.transferButton();
            transferButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
            RecipeBookmarkButton bookmarkButton = recipeLayoutWithButtons.bookmarkButton();
            bookmarkButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
        return Optional.ofNullable(hoveredLayout);
    }

    public void drawTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            recipeLayoutWithButtons.transferButton().drawTooltips(guiGraphics, mouseX, mouseY);
            recipeLayoutWithButtons.bookmarkButton().drawTooltips(guiGraphics, mouseX, mouseY);
        }
    }

    public int getWidth() {
        if (this.recipeLayoutsWithButtons.isEmpty()) {
            return 0;
        }
        RecipeLayoutWithButtons<?> first = this.recipeLayoutsWithButtons.get(0);
        return first.totalWidth();
    }
}

