/*
 * Decompiled with CFR 0.152.
 */
package me.steven.bodiesbodies.data.persistentstate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.steven.bodiesbodies.data.DeadBodyData;
import me.steven.bodiesbodies.data.persistentstate.DeathData;
import me.steven.bodiesbodies.data.persistentstate.PlayerBackup;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class DeathHistory
extends class_18 {
    private final class_3218 world;
    private int deathCounter = 0;
    private final Map<UUID, List<DeathData>> storedDeaths = new HashMap<UUID, List<DeathData>>();
    private final Map<Integer, PlayerBackup> playerNbtBackup = new HashMap<Integer, PlayerBackup>();

    public DeathHistory(class_3218 world) {
        this.world = world;
    }

    public List<DeathData> getDeathsFor(UUID uuid) {
        return this.storedDeaths.get(uuid);
    }

    public Map<Integer, PlayerBackup> getPlayerNbtBackup() {
        return this.playerNbtBackup;
    }

    public void removeDeathData(UUID uuid, int id) {
        this.storedDeaths.get(uuid).removeIf(d -> d.id() == id);
        this.playerNbtBackup.remove(id);
        this.method_80();
    }

    @Nullable
    public DeathData getDeathData(UUID uuid, int id) {
        if (!this.storedDeaths.containsKey(uuid)) {
            return null;
        }
        for (DeathData deathData : this.storedDeaths.get(uuid)) {
            if (deathData.id() != id) continue;
            return deathData;
        }
        return null;
    }

    public int save(int id, class_3222 player, class_2338 pos, List<DeadBodyData> data) {
        DeathData deathData = new DeathData(id, pos, player.method_37908().method_44013().method_29177(), data, System.currentTimeMillis());
        List deaths = this.storedDeaths.computeIfAbsent(player.method_5667(), x -> new ArrayList());
        deaths.add(deathData);
        this.method_80();
        return deathData.id();
    }

    public int backup(class_3222 player) {
        int id = this.deathCounter++;
        this.playerNbtBackup.put(id, new PlayerBackup(player.method_5647(new class_2487()), System.currentTimeMillis()));
        this.method_80();
        return id;
    }

    public int purgeOldEntries(DeathHistory purged) {
        AtomicInteger i = new AtomicInteger(0);
        this.playerNbtBackup.entrySet().removeIf(e -> {
            boolean remove;
            boolean bl = remove = ((PlayerBackup)e.getValue()).createdTime() + TimeUnit.DAYS.toMillis(7L) < System.currentTimeMillis();
            if (remove) {
                i.getAndIncrement();
                purged.playerNbtBackup.put((Integer)e.getKey(), (PlayerBackup)e.getValue());
            }
            return remove;
        });
        this.storedDeaths.forEach((uuid, deaths) -> deaths.removeIf(d -> {
            boolean remove;
            boolean bl = remove = d.createdTime() + TimeUnit.DAYS.toMillis(7L) < System.currentTimeMillis();
            if (remove) {
                i.getAndIncrement();
                purged.storedDeaths.computeIfAbsent((UUID)uuid, x -> new ArrayList()).add(d);
            }
            return remove;
        }));
        if (i.get() > 0) {
            System.out.println("Moved 1 week old entries to death_history_purged.dat");
            this.method_80();
        }
        return i.get();
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2487 rawPlayerNbt = new class_2487();
        this.playerNbtBackup.forEach((id, playerNbt) -> rawPlayerNbt.method_10566(id.toString(), (class_2520)playerNbt.writeNbt()));
        nbt.method_10566("RawNbt", (class_2520)rawPlayerNbt);
        nbt.method_10569("deathCounter", this.deathCounter);
        class_2487 deathsNbt = new class_2487();
        for (Map.Entry<UUID, List<DeathData>> entry : this.storedDeaths.entrySet()) {
            UUID uuid = entry.getKey();
            List<DeathData> deaths = entry.getValue();
            class_2499 list = new class_2499();
            for (DeathData death : deaths) {
                list.add((Object)death.writeNbt());
            }
            deathsNbt.method_10566(uuid.toString(), (class_2520)list);
        }
        nbt.method_10566("deaths", (class_2520)deathsNbt);
        return nbt;
    }

    public static DeathHistory readNbt(class_3218 world, class_2487 nbt) {
        DeathHistory data = new DeathHistory(world);
        class_2487 rawNbt = nbt.method_10562("RawNbt");
        for (String key : rawNbt.method_10541()) {
            int id = Integer.parseInt(key);
            data.playerNbtBackup.put(id, PlayerBackup.readNbt(rawNbt.method_10562(key)));
        }
        data.deathCounter = nbt.method_10550("deathCounter");
        class_2487 deathsNbt = nbt.method_10562("deaths");
        for (String uuidAsString : deathsNbt.method_10541()) {
            UUID uuid = UUID.fromString(uuidAsString);
            ArrayList<DeathData> deaths = new ArrayList<DeathData>();
            class_2499 list = deathsNbt.method_10554(uuidAsString, 10);
            for (class_2520 element : list) {
                deaths.add(DeathData.readNbt((class_2487)element));
            }
            data.storedDeaths.put(uuid, deaths);
        }
        return data;
    }

    public static DeathHistory getState(class_3218 world) {
        return (DeathHistory)world.method_8503().method_30002().method_17983().method_17924(nbt -> DeathHistory.readNbt(world, nbt), () -> new DeathHistory(world), "death_history");
    }
}

