/*
 * Decompiled with CFR 0.152.
 */
package me.steven.bodiesbodies;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import me.steven.bodiesbodies.BodiesBodies;
import me.steven.bodiesbodies.data.persistentstate.DeathData;
import me.steven.bodiesbodies.data.persistentstate.DeathHistory;
import me.steven.bodiesbodies.data.persistentstate.PlayerBackup;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BodiesBodiesCommands {
    public static void registerCommands() {
        BodiesBodiesCommands.registerDeathListCommand();
    }

    public static void registerDeathListCommand() {
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b, env) -> commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"deathhistory").requires(s -> s.method_9259(2))).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            BodiesBodiesCommands.showDeathData((CommandContext<class_2168>)ctx, player.method_5667(), ((class_2168)ctx.getSource()).method_9225());
            return 1;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"player");
            BodiesBodiesCommands.showDeathData((CommandContext<class_2168>)ctx, player.method_5667(), ((class_2168)ctx.getSource()).method_9225());
            return 1;
        }))));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b, env) -> commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restorebackup").requires(s -> s.method_9259(2))).then(class_2170.method_9244((String)"deathId", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            BodiesBodiesCommands.restoreNbtBackup((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"deathId"), ((class_2168)ctx.getSource()).method_9225());
            return 1;
        }))));
    }

    private static void showDeathData(CommandContext<class_2168> ctx, UUID uuid, class_3218 world) {
        List<DeathData> deathsFor = DeathHistory.getState(world).getDeathsFor(uuid);
        if (deathsFor == null || deathsFor.isEmpty()) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"No deaths for that player."));
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(deathsFor.size());
        List<DeathData> list = deathsFor.stream().sorted(Collections.reverseOrder(Comparator.comparingInt(DeathData::id))).limit(8L).toList();
        for (int i = 0; i < list.size(); ++i) {
            DeathData deathData = list.get(i);
            buf.writeInt(i);
            buf.method_10794(deathData.writeNbt());
        }
        ServerPlayNetworking.send((class_3222)((class_2168)ctx.getSource()).method_44023(), (class_2960)BodiesBodies.OPEN_DEATH_HISTORY, (class_2540)buf);
    }

    private static void restoreNbtBackup(CommandContext<class_2168> ctx, int id, class_3218 world) {
        PlayerBackup backup = DeathHistory.getState(world).getPlayerNbtBackup().get(id);
        if (backup == null) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("No backup found for death id " + id)));
            return;
        }
        class_2487 nbt = backup.data();
        UUID uuid = nbt.method_25926("UUID");
        class_3222 player = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14602(uuid);
        if (player == null) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("No player found for UUID " + String.valueOf(uuid))));
            return;
        }
        nbt.method_10551("Health");
        player.method_5651(nbt);
    }
}

