/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import reborncore.common.util.ExceptionUtils;

public final class TradeUtils {
    private TradeUtils() {
    }

    public static class_1914 createSell(class_1935 item, int price, int count, int maxUses, int experience) {
        return new class_1914(new class_1799((class_1935)class_1802.field_8687, price), new class_1799(item, count), maxUses, experience, 0.05f);
    }

    public static class_1914 createBuy(class_1935 item, int price, int count, int maxUses, int experience) {
        return new class_1914(new class_1799(item, count), new class_1799((class_1935)class_1802.field_8687, price), maxUses, experience, 0.05f);
    }

    @Contract(value="null -> null; !null -> new")
    public static class_1914 copy(class_1914 tradeOffer) {
        if (tradeOffer == null) {
            return null;
        }
        return new class_1914(tradeOffer.method_8251());
    }

    public static class_3853.class_1652 asFactory(final class_1914 tradeOffer) {
        return new class_3853.class_1652(){
            private final class_1914 offer;
            {
                this.offer = TradeUtils.copy(tradeOffer);
            }

            @Nullable
            public class_1914 method_7246(class_1297 entity, class_5819 random) {
                return TradeUtils.copy(this.offer);
            }
        };
    }

    public static void registerTradesForLevel(class_3852 profession, Level level, boolean replace, class_1914 ... tradeOffers) {
        class_3853.class_1652[] allLevelTrades;
        ExceptionUtils.requireNonNull(profession, "profession");
        ExceptionUtils.requireNonNull((Object)level, "level");
        ExceptionUtils.requireNonNull(tradeOffers, "tradeOffers");
        ExceptionUtils.requireNonNullEntries(tradeOffers, "tradeOffers");
        Int2ObjectMap allTrades = (Int2ObjectMap)class_3853.field_17067.getOrDefault(profession, new Int2ObjectArrayMap(Level.SIZE));
        class_3853.class_1652[] oldLevelTrades = (class_3853.class_1652[])allTrades.getOrDefault(level.asInt(), (Object)new class_3853.class_1652[0]);
        class_3853.class_1652[] newLevelTrades = new class_3853.class_1652[tradeOffers.length];
        newLevelTrades = Arrays.stream(tradeOffers).map(TradeUtils::asFactory).collect(Collectors.toList()).toArray(newLevelTrades);
        if (replace) {
            allLevelTrades = newLevelTrades;
        } else {
            allLevelTrades = new class_3853.class_1652[oldLevelTrades.length + newLevelTrades.length];
            System.arraycopy(oldLevelTrades, 0, allLevelTrades, 0, oldLevelTrades.length);
            System.arraycopy(newLevelTrades, 0, allLevelTrades, oldLevelTrades.length, newLevelTrades.length);
        }
        allTrades.put(level.asInt(), (Object)allLevelTrades);
        class_3853.field_17067.put(profession, allTrades);
    }

    public static enum Level {
        NOVICE,
        APPRENTICE,
        JOURNEYMAN,
        EXPERT,
        MASTER;

        public static final int SIZE;

        public int asInt() {
            return this.ordinal() + 1;
        }

        static {
            SIZE = MASTER.ordinal() + 1;
        }
    }
}

