/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.apache.commons.lang3.Validate;
import reborncore.common.crafting.ingredient.RebornIngredient;

public class StackIngredient
extends RebornIngredient {
    private final class_1799 stack;
    private final Optional<Integer> count;
    private final Optional<class_2487> nbt;
    private final boolean requireEmptyNbt;

    public StackIngredient(class_1799 stack, Optional<Integer> count, Optional<class_2487> nbt, boolean requireEmptyNbt) {
        this.stack = stack;
        this.count = Objects.requireNonNull(count);
        this.nbt = Objects.requireNonNull(nbt);
        this.requireEmptyNbt = requireEmptyNbt;
        Validate.isTrue((!stack.method_7960() ? 1 : 0) != 0, (String)"ingredient must not empty", (Object[])new Object[0]);
    }

    public static RebornIngredient deserialize(JsonObject json) {
        class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)json, (String)"item"));
        class_1792 item = (class_1792)class_7923.field_41178.method_17966(identifier).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + String.valueOf(identifier) + "'"));
        Optional<Integer> stackSize = Optional.empty();
        if (json.has("count")) {
            stackSize = Optional.of(class_3518.method_15260((JsonObject)json, (String)"count"));
        }
        Optional<class_2487> tag = Optional.empty();
        boolean requireEmptyTag = false;
        if (json.has("nbt")) {
            if (!json.get("nbt").isJsonObject()) {
                if (json.get("nbt").getAsString().equals("empty")) {
                    requireEmptyTag = true;
                }
            } else {
                tag = Optional.of((class_2487)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)class_2509.field_11560, (Object)json.get("nbt")));
            }
        }
        return new StackIngredient(new class_1799((class_1935)item), stackSize, tag, requireEmptyTag);
    }

    @Override
    public boolean test(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        if (this.stack.method_7909() != itemStack.method_7909()) {
            return false;
        }
        if (this.count.isPresent() && this.count.get() > itemStack.method_7947()) {
            return false;
        }
        if (this.nbt.isPresent()) {
            if (!itemStack.method_7985()) {
                return false;
            }
            class_2487 compoundTag = itemStack.method_7969();
            JsonElement jsonElement = (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)compoundTag);
            compoundTag = (class_2487)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)class_2509.field_11560, (Object)jsonElement);
            if (!this.nbt.get().equals((Object)compoundTag)) {
                return false;
            }
        }
        return !this.requireEmptyNbt || !itemStack.method_7985();
    }

    @Override
    public class_1856 getPreview() {
        return class_1856.method_26964(this.getPreviewStacks().stream());
    }

    @Override
    public List<class_1799> getPreviewStacks() {
        class_1799 copy = this.stack.method_7972();
        copy.method_7939(this.count.orElse(1).intValue());
        copy.method_7980((class_2487)this.nbt.orElse(null));
        return Collections.singletonList(copy);
    }

    @Override
    public JsonObject toJson(boolean networkSync) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.stack.method_7909()).toString());
        this.count.ifPresent(integer -> jsonObject.addProperty("count", (Number)integer));
        if (this.requireEmptyNbt) {
            jsonObject.addProperty("nbt", "empty");
        } else {
            this.nbt.ifPresent(compoundTag -> jsonObject.add("nbt", (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)compoundTag)));
        }
        return jsonObject;
    }

    @Override
    public int getCount() {
        return this.count.orElse(1);
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public Optional<class_2487> getNbt() {
        return this.nbt;
    }

    public boolean isRequireEmptyNbt() {
        return this.requireEmptyNbt;
    }
}

