/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import org.joml.Matrix4f;
import reborncore.client.ClientNetworkManager;
import reborncore.common.chunkloading.ChunkLoaderManager;
import reborncore.common.network.ServerBoundPackets;

@Environment(value=EnvType.CLIENT)
public class ClientChunkManager {
    private static final List<ChunkLoaderManager.LoadedChunk> loadedChunks = new ArrayList<ChunkLoaderManager.LoadedChunk>();

    public static void setLoadedChunks(List<ChunkLoaderManager.LoadedChunk> chunks) {
        loadedChunks.clear();
        loadedChunks.addAll(chunks);
    }

    public static void toggleLoadedChunks(class_2338 chunkLoader) {
        if (loadedChunks.isEmpty()) {
            ClientNetworkManager.sendToServer(ServerBoundPackets.requestChunkLoaderChunks(chunkLoader));
        } else {
            loadedChunks.clear();
        }
    }

    public static boolean isShow() {
        return !loadedChunks.isEmpty();
    }

    public static boolean hasChunksForLoader(class_2338 pos) {
        return loadedChunks.stream().filter(loadedChunk -> loadedChunk.getChunkLoader().equals((Object)pos)).anyMatch(loadedChunk -> loadedChunk.getWorld().equals((Object)ChunkLoaderManager.getWorldName((class_1937)class_310.method_1551().field_1687)));
    }

    public static void render(class_4587 matrices, class_4597 vertexConsumers, double x, double y, double z) {
        int j;
        int i;
        int size = loadedChunks.size();
        if (size == 0) {
            return;
        }
        class_310 minecraftClient = class_310.method_1551();
        class_2960 worldName = ChunkLoaderManager.getWorldName((class_1937)minecraftClient.field_1687);
        int[] posX = new int[size];
        int[] posZ = new int[size];
        int right = 0;
        int maxX = Integer.MIN_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < size; ++i2) {
            ChunkLoaderManager.LoadedChunk chunk = loadedChunks.get(i2);
            if (!chunk.getWorld().equals((Object)worldName)) continue;
            class_1923 pos = chunk.getChunk();
            int startX = posX[right] = pos.method_8326();
            int startZ = posZ[right] = pos.method_8328();
            if (maxX < startX) {
                maxX = startX;
            }
            if (minX > startX) {
                minX = startX;
            }
            if (maxZ < startZ) {
                maxZ = startZ;
            }
            if (minZ > startZ) {
                minZ = startZ;
            }
            ++right;
        }
        if (right == 0) {
            return;
        }
        size = right;
        int bottom = minecraftClient.field_1687.method_31607();
        int top = minecraftClient.field_1687.method_31600();
        DrawContext ctx = new DrawContext(vertexConsumers.getBuffer(class_1921.method_49043((double)1.0)), matrices.method_23760().method_23761(), x, y, z, bottom, top);
        int chunkSize = 16;
        int middle = chunkSize / 2;
        int end = chunkSize;
        for (i = 0; i < size; ++i) {
            ctx.updatePos(posX[i], posZ[i]);
            ctx.drawVerticalRed(middle, middle);
            if (posX[i] == minX) {
                ctx.drawVerticalBlue(0, 0);
                for (j = 2; j < chunkSize; j += 4) {
                    ctx.drawVerticalYellow(0, j);
                }
                for (j = 4; j < chunkSize; j += 4) {
                    ctx.drawVerticalCyan(0, j);
                }
            }
            if (posX[i] == maxX) {
                ctx.drawVerticalBlue(end, end);
                for (j = 2; j < chunkSize; j += 4) {
                    ctx.drawVerticalYellow(end, j);
                }
                for (j = 4; j < chunkSize; j += 4) {
                    ctx.drawVerticalCyan(end, j);
                }
            }
            if (posZ[i] == minZ) {
                ctx.drawVerticalBlue(end, 0);
                for (j = 2; j < chunkSize; j += 4) {
                    ctx.drawVerticalYellow(j, 0);
                }
                for (j = 4; j < chunkSize; j += 4) {
                    ctx.drawVerticalCyan(j, 0);
                }
            }
            if (posZ[i] != maxZ) continue;
            ctx.drawVerticalBlue(0, end);
            for (j = 2; j < chunkSize; j += 4) {
                ctx.drawVerticalYellow(j, end);
            }
            for (j = 4; j < chunkSize; j += 4) {
                ctx.drawVerticalCyan(j, end);
            }
        }
        ctx.updatePos(minX, minZ, maxX + chunkSize, maxZ + chunkSize);
        i = bottom;
        while (i < top) {
            ctx.drawHorizontalBlue(i);
            j = i + middle;
            ctx.drawHorizontalCyan(j);
            int stop = (i += 2) + 12;
            while (i <= stop) {
                if (i != j) {
                    ctx.drawHorizontalYellow(i);
                }
                i += 2;
            }
        }
        ctx.drawHorizontalBlue(top);
    }

    @Environment(value=EnvType.CLIENT)
    static class DrawContext {
        private static final int NONE = class_5253.class_5254.method_27764((int)0, (int)0, (int)0, (int)0);
        private static final int RED = class_5253.class_5254.method_27764((int)127, (int)255, (int)0, (int)0);
        private static final int BLUE = class_5253.class_5254.method_27764((int)255, (int)63, (int)63, (int)255);
        private static final int DARK_CYAN = class_5253.class_5254.method_27764((int)255, (int)0, (int)155, (int)155);
        private static final int YELLOW = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)0);
        private final class_4588 vertexConsumer;
        private final Matrix4f matrix4f;
        private final double cameraX;
        private final double cameraY;
        private final double cameraZ;
        private final float bottom;
        private final float top;
        private float x1 = 0.0f;
        private float z1 = 0.0f;
        private float x2 = 0.0f;
        private float z2 = 0.0f;

        DrawContext(class_4588 vertexConsumer, Matrix4f matrix4f, double cameraX, double cameraY, double cameraZ, int bottom, int top) {
            this.vertexConsumer = vertexConsumer;
            this.matrix4f = matrix4f;
            this.cameraX = cameraX;
            this.cameraY = cameraY;
            this.cameraZ = cameraZ;
            this.bottom = (float)((double)bottom - cameraY);
            this.top = (float)((double)top - cameraY);
        }

        public void updatePos(float x, float z) {
            this.x1 = (float)((double)x - this.cameraX);
            this.z1 = (float)((double)z - this.cameraZ);
        }

        public void updatePos(float x1, float z1, float x2, float z2) {
            this.x1 = (float)((double)x1 - this.cameraX);
            this.z1 = (float)((double)z1 - this.cameraZ);
            this.x2 = (float)((double)x2 - this.cameraX);
            this.z2 = (float)((double)z2 - this.cameraZ);
        }

        public void drawVertical(int color, float x, float z) {
            this.vertexConsumer.method_22918(this.matrix4f, x, this.bottom, z).method_39415(NONE).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, x, this.bottom, z).method_39415(color).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, x, this.top, z).method_39415(color).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, x, this.top, z).method_39415(NONE).method_1344();
        }

        public void drawVerticalRed(int x, int z) {
            this.drawVertical(RED, this.x1 + (float)x, this.z1 + (float)z);
        }

        public void drawVerticalBlue(int x, int z) {
            this.drawVertical(BLUE, this.x1 + (float)x, this.z1 + (float)z);
        }

        public void drawVerticalYellow(int x, int z) {
            this.drawVertical(YELLOW, this.x1 + (float)x, this.z1 + (float)z);
        }

        public void drawVerticalCyan(int x, int z) {
            this.drawVertical(DARK_CYAN, this.x1 + (float)x, this.z1 + (float)z);
        }

        public void drawHorizontal(int color, float y) {
            this.vertexConsumer.method_22918(this.matrix4f, this.x1, y, this.z1).method_39415(NONE).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, this.x1, y, this.z1).method_39415(color).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, this.x1, y, this.z2).method_39415(color).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, this.x2, y, this.z2).method_39415(color).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, this.x2, y, this.z1).method_39415(color).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, this.x1, y, this.z1).method_39415(color).method_1344();
            this.vertexConsumer.method_22918(this.matrix4f, this.x1, y, this.z1).method_39415(NONE).method_1344();
        }

        public void drawHorizontalBlue(int y) {
            this.drawHorizontal(BLUE, (float)((double)y - this.cameraY));
        }

        public void drawHorizontalYellow(int y) {
            this.drawHorizontal(YELLOW, (float)((double)y - this.cameraY));
        }

        public void drawHorizontalCyan(int y) {
            this.drawHorizontal(DARK_CYAN, (float)((double)y - this.cameraY));
        }
    }
}

