/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import journeymap.common.Journeymap;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import journeymap.common.version.Version;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7439;

public class HandshakePacket {
    public static final class_2960 CHANNEL = new class_2960("journeymap", "version");
    private String version;

    public HandshakePacket() {
    }

    public HandshakePacket(String version) {
        this.version = version;
    }

    public static HandshakePacket decode(class_2540 buf) {
        HandshakePacket packet = new HandshakePacket();
        try {
            if (buf.readableBytes() > 1) {
                packet.version = buf.method_10800(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for handshake: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            buf.method_10814(this.version);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message for handshake: " + t);
        }
    }

    public static void handle(PacketContext<HandshakePacket> ctx) {
        String jsonString = ctx.message().version;
        try {
            Version otherVersion = Version.fromJson(jsonString);
            if (Side.CLIENT.equals((Object)ctx.side())) {
                if (!otherVersion.isValid(Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION, ctx.side())) {
                    String message = "Journeymap Version Mismatch need at least " + Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION + " or higher. Current " + ctx.side().opposite() + " version attempt -> " + otherVersion;
                    class_310.method_1551().field_1724.field_3944.method_48296().method_10747((class_2561)class_2561.method_43470((String)message));
                }
            } else if (otherVersion.isValid(Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION, ctx.side())) {
                Journeymap.getInstance().getDispatcher().sendHandshakePacket(ctx.sender(), Journeymap.JM_VERSION.toJson());
            } else {
                String message = "Journeymap Version Mismatch need at least " + Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION + " or higher. Current " + ctx.side().opposite() + " version attempt -> " + otherVersion;
                HandshakePacket.disconnect(ctx.sender(), message);
            }
        }
        catch (Exception e) {
            String message = "Error: Likely due to version mismatch " + ctx.side() + " is running:" + Journeymap.JM_VERSION + " Exception:" + e;
            HandshakePacket.disconnect(ctx.sender(), message + e);
        }
    }

    public static void disconnect(class_3222 player, String message) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        class_5250 text = class_2561.method_43470((String)message);
        player.field_13987.method_14364((class_2596)new class_7439((class_2561)text, false));
        executorService.schedule(() -> HandshakePacket.lambda$disconnect$0(player, (class_2561)text), 1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void lambda$disconnect$0(class_3222 player, class_2561 text) {
        player.field_13987.method_14367(text);
    }
}

