/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import java.util.ArrayList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.config.ConfigField;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class SlotMetadata<T>
implements Comparable<SlotMetadata> {
    protected final Button button;
    protected final String range;
    protected final T defaultValue;
    protected final ValueType valueType;
    protected String name;
    protected String tooltip;
    protected boolean advanced;
    protected List<class_5481> tooltipLines;
    protected List valueList;
    protected boolean master;
    protected int order;

    public SlotMetadata(Button button) {
        this(button, false);
    }

    public SlotMetadata(Button button, int order) {
        this(button, false);
        this.order = order;
    }

    public SlotMetadata(Button button, boolean advanced) {
        this(button, button.getDisplayString(), button.getUnformattedTooltip(), null, null, advanced);
    }

    public SlotMetadata(Button button, String name, String tooltip, boolean advanced) {
        this(button, name, tooltip, null, null, advanced);
    }

    public SlotMetadata(Button button, String name, String tooltip) {
        this(button, name, tooltip, null, null, false);
    }

    public SlotMetadata(Button button, String name, String tooltip, int order) {
        this(button, name, tooltip, null, null, false);
        this.order = order;
    }

    public SlotMetadata(Button button, String name, String tooltip, String range, T defaultValue, boolean advanced) {
        this.button = button;
        this.name = name;
        this.tooltip = tooltip;
        this.range = range;
        this.defaultValue = defaultValue;
        this.advanced = advanced;
        this.valueType = defaultValue == null && range == null && !advanced ? ValueType.Toolbar : (defaultValue instanceof Boolean ? ValueType.Boolean : (defaultValue instanceof Integer ? ValueType.Integer : ValueType.Set));
    }

    public boolean isMasterPropertyForCategory() {
        return this.master;
    }

    public void setMasterPropertyForCategory(boolean master) {
        this.master = master;
    }

    public Button getButton() {
        return this.button;
    }

    public String getName() {
        return this.name;
    }

    public String getRange() {
        return this.range;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public List<class_5481> getTooltipLines() {
        return this.tooltipLines;
    }

    public boolean isMaster() {
        return this.master;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isToolbar() {
        return this.valueType == ValueType.Toolbar;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public List getValueList() {
        return this.valueList;
    }

    public void setValueList(List valueList) {
        this.valueList = valueList;
    }

    public void updateFromButton() {
        if (this.button != null) {
            this.name = this.button.getDisplayString();
            this.tooltip = this.button.getUnformattedTooltip();
            this.tooltipLines = null;
        }
    }

    public List<class_5481> getTooltip() {
        if (this.tooltipLines == null) {
            ArrayList<class_5481> lines = new ArrayList<class_5481>(4);
            if (this.tooltip != null || this.range != null || this.defaultValue != null || this.advanced) {
                class_124 nameColor = this.isToolbar() ? class_124.field_1060 : (this.advanced ? class_124.field_1061 : class_124.field_1075);
                String formattedName = class_2561.method_43469((String)"jm.config.tooltip_format", (Object[])new Object[]{this.name}).getString();
                lines.add(class_5481.method_30747((String)formattedName, (class_2583)class_2583.field_24360.method_27706(nameColor)));
                if (this.tooltip != null) {
                    lines.addAll(this.getWordWrappedLines(this.tooltip, class_2583.field_24360.method_27706(class_124.field_1054)));
                }
                if (this.button != null && this.button instanceof IntSliderButton) {
                    class_2583 style = class_2583.field_24360.method_27705(new class_124[]{class_124.field_1080, class_124.field_1056});
                    lines.addAll(this.getWordWrappedLines(Constants.getString("jm.config.control_arrowkeys"), style));
                }
                if (this.range != null) {
                    String formattedRange = class_2561.method_43469((String)"jm.config.tooltip_format", (Object[])new Object[]{this.range}).getString();
                    lines.add(class_5481.method_30747((String)formattedRange, (class_2583)class_2583.field_24360.method_27706(class_124.field_1068)));
                }
            }
            if (!lines.isEmpty()) {
                return lines;
            }
        }
        return this.tooltipLines;
    }

    protected List<class_5481> getWordWrappedLines(String original, class_2583 style) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        ArrayList<class_5481> list = new ArrayList<class_5481>();
        int max = fontRenderer.method_1726() ? 170 : 250;
        for (class_5348 line : fontRenderer.method_27527().method_27495((class_5348)Constants.getStringTextComponent(original), max, style)) {
            list.add(class_5481.method_30747((String)class_2561.method_43469((String)"jm.config.tooltip_format", (Object[])new Object[]{line.getString()}).getString(), (class_2583)style));
        }
        return list;
    }

    public void resetToDefaultValue() {
        if (this.button != null) {
            if (this.button instanceof IConfigFieldHolder) {
                try {
                    Object configField = ((IConfigFieldHolder)((Object)this.button)).getConfigField();
                    if (configField != null) {
                        ((ConfigField)configField).setToDefault();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.button.refresh();
        }
    }

    public boolean hasConfigField() {
        return this.button != null && this.button instanceof IConfigFieldHolder && ((IConfigFieldHolder)((Object)this.button)).getConfigField() != null;
    }

    public PropertiesBase getProperties() {
        if (this.hasConfigField()) {
            return ((ConfigField)((IConfigFieldHolder)((Object)this.button)).getConfigField()).getOwner();
        }
        return null;
    }

    @Override
    public int compareTo(SlotMetadata other) {
        int result = Boolean.compare(this.isToolbar(), other.isToolbar());
        if (result == 0) {
            result = Integer.compare(this.order, other.order);
        }
        if (result == 0) {
            result = Boolean.compare(other.master, this.master);
        }
        if (result == 0) {
            result = this.valueType.compareTo(other.valueType);
        }
        if (result == 0) {
            result = this.name.compareTo(other.name);
        }
        return result;
    }

    public static enum ValueType {
        Boolean,
        Set,
        Integer,
        Toolbar;

    }
}

