/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.base.MoreObjects;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.log.JMLogger;
import journeymap.client.render.RenderWrapper;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.texture.DynamicTextureImpl;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.Texture;
import journeymap.common.Journeymap;
import net.minecraft.class_1011;
import net.minecraft.class_1923;
import net.minecraft.class_3300;

public class RegionTexture
extends DynamicTextureImpl
implements Texture {
    protected final ReentrantLock bufferLock = new ReentrantLock();
    protected HashSet<class_1923> dirtyChunks = new HashSet();
    protected List<WeakReference<Listener>> listeners = new ArrayList<WeakReference<Listener>>(0);
    protected long lastImageUpdate;
    protected String description;
    protected boolean bindNeeded;
    protected long lastBound;
    protected class_1011 image;
    protected class_1011 renderTarget;
    protected int width;
    protected int height;

    public RegionTexture(class_1011 pixels, String description) {
        super(pixels);
        this.setNativeImage(pixels, true);
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_23207() {
        if (this.bindNeeded && this.bufferLock.tryLock()) {
            try {
                int err;
                if (this.field_5204 == -1) {
                    this.field_5204 = this.method_4624();
                }
                super.method_23207();
                if (this.lastBound == 0L || this.dirtyChunks.isEmpty()) {
                    RenderWrapper.texParameter(3553, 33085, 0);
                    RenderWrapper.texParameter(3553, 33082, 0);
                    RenderWrapper.texParameter(3553, 33083, 0);
                    RenderWrapper.texParameter(3553, 34049, 0);
                    RenderWrapper.texImage2D(3553, 0, this.renderTarget.method_4318().method_4333(), this.renderTarget.method_4307(), this.renderTarget.method_4323(), 0, 6408, 5121, null);
                    this.renderTarget.method_4301(0, 0, 0, false);
                    this.bindNeeded = false;
                    this.lastBound = System.currentTimeMillis();
                    return;
                }
                for (class_1923 pos : this.dirtyChunks) {
                    class_1011 chunkImage = ImageUtil.getSubImage(pos.field_9181, pos.field_9180, 16, 16, this.image, false);
                    try {
                        chunkImage.method_4312(0, pos.field_9181, pos.field_9180, 0, 0, 16, 16, false, false);
                    }
                    finally {
                        if (chunkImage == null) continue;
                        chunkImage.close();
                    }
                }
                while ((err = RenderWrapper.getError()) != 0) {
                    JMLogger.logOnce("GL Error in RegionTexture after upload: " + err + " in " + this);
                }
                this.dirtyChunks.clear();
                this.lastBound = System.currentTimeMillis();
                this.bindNeeded = false;
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Can't bind texture: ", t);
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    public long getLastImageUpdate() {
        return this.lastImageUpdate;
    }

    public boolean isBound() {
        return this.field_5204 != -1;
    }

    public boolean isDefunct() {
        return this.image == null && this.field_5204 == -1 || this.image.field_4988 == 0L;
    }

    public class_1011 getSubImage(int x, int y, int height, int width) {
        return ImageUtil.getSubImage(x, y, width, height, this.image, false);
    }

    @Override
    public void setNativeImage(class_1011 image, boolean retainImage) {
        if (image == null) {
            return;
        }
        try {
            this.bufferLock.lock();
            if (this.renderTarget == null || this.renderTarget.field_4988 == 0L) {
                this.renderTarget = new class_1011(image.method_4307(), image.method_4323(), false);
            }
            this.renderTarget.method_4317(image);
            this.handleImage(image, retainImage);
            this.bindNeeded = true;
        }
        finally {
            this.bufferLock.unlock();
        }
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    public void setNativeImage(class_1011 image, boolean retainImage, HashSet<class_1923> updatedChunks) {
        if (updatedChunks.size() > 15) {
            this.setNativeImage(image, retainImage);
        } else {
            this.handleImage(image, retainImage);
        }
        this.dirtyChunks.addAll(updatedChunks);
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    private void handleImage(class_1011 image, boolean retainImage) {
        this.bindNeeded = true;
        try {
            this.bufferLock.lock();
            this.width = image.method_4307();
            this.height = image.method_4323();
            if (retainImage) {
                if (this.image == null) {
                    this.image = image;
                } else if (image.field_4988 != this.image.field_4988) {
                    this.image.method_4317(image);
                }
            }
            if (image.field_4988 != this.image.field_4988) {
                image.close();
            }
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    public Set<class_1923> getDirtyAreas() {
        return this.dirtyChunks;
    }

    public void addListener(Listener addedListener) {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            if (addedListener != listener) continue;
            return;
        }
        this.listeners.add(new WeakReference<Listener>(addedListener));
    }

    protected void notifyListeners() {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            listener.textureImageUpdated(this);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("glid", this.field_5204).add("description", (Object)this.description).add("lastImageUpdate", this.lastImageUpdate).toString();
    }

    public boolean bindNeeded() {
        return this.bindNeeded;
    }

    @Override
    public int getWidth() {
        return this.image.method_4307();
    }

    @Override
    public int getHeight() {
        return this.image.method_4323();
    }

    @Override
    public void setDisplayWidth(int width) {
    }

    @Override
    public void setDisplayHeight(int height) {
    }

    @Override
    public Texture getScaledImage(float drawScale) {
        return null;
    }

    @Override
    public int getTextureId() {
        return this.field_5204;
    }

    @Override
    public boolean hasImage() {
        return this.image != null && this.image.field_4988 > 0L;
    }

    @Override
    public void remove() {
        this.bufferLock.lock();
        ImageUtil.clearAndClose(this.image);
        ImageUtil.clearAndClose(this.renderTarget);
        this.bufferLock.unlock();
        this.bindNeeded = false;
        this.image = null;
        this.renderTarget = null;
        this.lastImageUpdate = 0L;
        this.lastBound = 0L;
        this.field_5204 = -1;
    }

    public void close() {
        if (this.isBound()) {
            ExpireTextureTask.queue(this.field_5204);
        }
        this.image.close();
    }

    @Override
    public void setNativeImage(class_1011 image) {
        this.setNativeImage(image, true);
    }

    @Override
    public class_1011 getNativeImage() {
        return this.image;
    }

    @Override
    public float getAlpha() {
        return 0.0f;
    }

    @Override
    public void setAlpha(float alpha) {
    }

    public void method_4625(class_3300 pResourceManager) {
    }

    public static interface Listener<T extends Texture> {
        public void textureImageUpdated(T var1);
    }
}

