/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import link.infra.indium.Indium;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.aocalc.AoConfig;
import link.infra.indium.renderer.helper.ColorHelper;
import link.infra.indium.renderer.material.RenderMaterialImpl;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.AbstractRenderContext;
import link.infra.indium.renderer.render.BlockRenderInfo;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.renderer.VanillaModelEncoder;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_765;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class AbstractBlockRenderContext
extends AbstractRenderContext {
    protected BlockRenderInfo blockInfo;
    protected AoCalculator aoCalc;
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            AbstractBlockRenderContext.this.renderQuad(this, false);
        }
    };
    private final MutableQuadViewImpl vanillaModelEditorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            AbstractBlockRenderContext.this.renderQuad(this, true);
        }
    };
    private final BakedModelConsumerImpl vanillaModelConsumer = new BakedModelConsumerImpl();

    protected abstract LightDataAccess getLightCache();

    protected abstract void bufferQuad(MutableQuadViewImpl var1, Material var2);

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public QuadEmitter getVanillaModelEmitter() {
        return this.vanillaModelEditorQuad;
    }

    public boolean isFaceCulled(@Nullable class_2350 face) {
        return !this.blockInfo.shouldDrawFace(face);
    }

    public class_811 itemTransformationMode() {
        throw new IllegalStateException("itemTransformationMode() can only be called on an item render context.");
    }

    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.vanillaModelConsumer;
    }

    private void renderQuad(MutableQuadViewImpl quad, boolean isVanilla) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        if (this.isFaceCulled(quad.cullFace())) {
            return;
        }
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        TriState aoMode = mat.ambientOcclusion();
        boolean ao = this.blockInfo.useAo && (aoMode == TriState.TRUE || aoMode == TriState.DEFAULT && this.blockInfo.defaultAo);
        boolean emissive = mat.emissive();
        class_1921 renderLayer = this.blockInfo.effectiveRenderLayer(mat.blendMode());
        Material sodiumMaterial = DefaultMaterials.forRenderLayer((class_1921)renderLayer);
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, isVanilla, ao, emissive);
        this.bufferQuad(quad, sodiumMaterial);
    }

    private void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        if (colorIndex != -1) {
            int blockColor = this.blockInfo.blockColor(colorIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(blockColor, quad.color(i)));
            }
        }
    }

    protected void shadeQuad(MutableQuadViewImpl quad, boolean isVanilla, boolean ao, boolean emissive) {
        if (ao) {
            this.aoCalc.compute(quad, isVanilla);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.aoCalc.ao[i]));
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.aoCalc.ao[i]));
                    quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), this.aoCalc.light[i]));
                }
            }
        } else {
            this.shadeFlatQuad(quad, isVanilla);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                int brightness = this.flatBrightness(quad);
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), brightness));
                }
            }
        }
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad, boolean isVanilla) {
        block9: {
            boolean hasShade;
            block7: {
                float faceShade;
                block10: {
                    block8: {
                        hasShade = quad.hasShade();
                        if ((Indium.AMBIENT_OCCLUSION_MODE != AoConfig.HYBRID || isVanilla) && Indium.AMBIENT_OCCLUSION_MODE != AoConfig.ENHANCED) break block7;
                        if (!quad.hasAllVertexNormals()) break block8;
                        for (int i = 0; i < 4; ++i) {
                            float shade = this.normalShade(quad.normalX(i), quad.normalY(i), quad.normalZ(i), hasShade);
                            quad.color(i, ColorHelper.multiplyRGB(quad.color(i), shade));
                        }
                        break block9;
                    }
                    if ((quad.geometryFlags() & 2) != 0) {
                        faceShade = this.blockInfo.blockView.method_24852(quad.lightFace(), hasShade);
                    } else {
                        Vector3f faceNormal = quad.faceNormal();
                        faceShade = this.normalShade(faceNormal.x, faceNormal.y, faceNormal.z, hasShade);
                    }
                    if (!quad.hasVertexNormals()) break block10;
                    for (int i = 0; i < 4; ++i) {
                        float shade = quad.hasNormal(i) ? this.normalShade(quad.normalX(i), quad.normalY(i), quad.normalZ(i), hasShade) : faceShade;
                        quad.color(i, ColorHelper.multiplyRGB(quad.color(i), shade));
                    }
                    break block9;
                }
                if (faceShade == 1.0f) break block9;
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), faceShade));
                }
                break block9;
            }
            float faceShade = this.blockInfo.blockView.method_24852(quad.lightFace(), hasShade);
            if (faceShade != 1.0f) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), faceShade));
                }
            }
        }
    }

    private float normalShade(float normalX, float normalY, float normalZ, boolean hasShade) {
        float sum = 0.0f;
        float div = 0.0f;
        if (normalX > 0.0f) {
            sum += normalX * this.blockInfo.blockView.method_24852(class_2350.field_11034, hasShade);
            div += normalX;
        } else if (normalX < 0.0f) {
            sum += -normalX * this.blockInfo.blockView.method_24852(class_2350.field_11039, hasShade);
            div -= normalX;
        }
        if (normalY > 0.0f) {
            sum += normalY * this.blockInfo.blockView.method_24852(class_2350.field_11036, hasShade);
            div += normalY;
        } else if (normalY < 0.0f) {
            sum += -normalY * this.blockInfo.blockView.method_24852(class_2350.field_11033, hasShade);
            div -= normalY;
        }
        if (normalZ > 0.0f) {
            sum += normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11035, hasShade);
            div += normalZ;
        } else if (normalZ < 0.0f) {
            sum += -normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11043, hasShade);
            div -= normalZ;
        }
        return sum / div;
    }

    private int flatBrightness(MutableQuadViewImpl quad) {
        LightDataAccess lightCache = this.getLightCache();
        class_2338 pos = this.blockInfo.blockPos;
        class_2350 cullFace = quad.cullFace();
        if (cullFace != null) {
            return AbstractBlockRenderContext.getOffsetLightmap(lightCache, pos, cullFace);
        }
        int flags = quad.geometryFlags();
        if ((flags & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC((int)lightCache.get(pos))) {
            return AbstractBlockRenderContext.getOffsetLightmap(lightCache, pos, quad.lightFace());
        }
        return LightDataAccess.getEmissiveLightmap((int)lightCache.get(pos));
    }

    private static int getOffsetLightmap(LightDataAccess lightCache, class_2338 pos, class_2350 face) {
        int word = lightCache.get(pos);
        if (LightDataAccess.unpackEM((int)word)) {
            return 0xF000F0;
        }
        int adjWord = lightCache.get(pos, face);
        return class_765.method_23687((int)Math.max(LightDataAccess.unpackBL((int)adjWord), LightDataAccess.unpackLU((int)word)), (int)LightDataAccess.unpackSL((int)adjWord));
    }

    private class BakedModelConsumerImpl
    implements RenderContext.BakedModelConsumer {
        private BakedModelConsumerImpl() {
        }

        public void accept(class_1087 model) {
            this.accept(model, AbstractBlockRenderContext.this.blockInfo.blockState);
        }

        public void accept(class_1087 model, @Nullable class_2680 state) {
            VanillaModelEncoder.emitBlockQuads((class_1087)model, (class_2680)state, AbstractBlockRenderContext.this.blockInfo.randomSupplier, (RenderContext)AbstractBlockRenderContext.this, (QuadEmitter)AbstractBlockRenderContext.this.vanillaModelEditorQuad);
        }
    }
}

