/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.utils;

public class CircularShortBuffer {
    private short[] buffer;
    private int position;
    private int size;

    public CircularShortBuffer(int capacity) {
        this.buffer = new short[capacity];
        this.position = 0;
        this.size = 0;
    }

    public void add(short[] data, int offset, int length) {
        if (length > this.getFreeSpace()) {
            throw new IndexOutOfBoundsException("Not enough space in buffer");
        }
        for (int i = offset; i < offset + length; ++i) {
            this.buffer[this.position] = data[i];
            this.position = (this.position + 1) % this.maxCapacity();
        }
        this.size = Math.min(this.size + length, this.maxCapacity());
    }

    public void add(short[] data) {
        this.add(data, 0, data.length);
    }

    public int get(short[] dest, int offset, int length) {
        int elementsToRead = Math.min(length, this.size);
        for (int i = 0; i < elementsToRead; ++i) {
            dest[offset + i] = this.buffer[(this.position - this.size + this.maxCapacity()) % this.maxCapacity()];
            --this.size;
        }
        return elementsToRead;
    }

    public int get(short[] dest) {
        return this.get(dest, 0, dest.length);
    }

    public int peek(short[] dest, int offset, int length) {
        int fakeSize = this.size;
        int elementsToRead = Math.min(length, fakeSize);
        for (int i = 0; i < elementsToRead; ++i) {
            dest[offset + i] = this.buffer[(this.position - fakeSize + this.maxCapacity()) % this.maxCapacity()];
            --fakeSize;
        }
        return elementsToRead;
    }

    public int peek(short[] dest) {
        return this.peek(dest, 0, dest.length);
    }

    public void skip(int length) {
        this.size = Math.max(this.size - length, 0);
    }

    public void clear() {
        this.position = 0;
        this.size = 0;
    }

    public int getFreeSpace() {
        return this.maxCapacity() - this.size;
    }

    public int maxCapacity() {
        return this.buffer.length;
    }

    public int sizeUsed() {
        return this.size;
    }

    public boolean hasRemaining() {
        return this.sizeUsed() > 0;
    }
}

