/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.radio;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import de.maxhenkel.radio.Radio;
import de.maxhenkel.radio.utils.HeadUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class RadioData {
    public static final UUID RADIO_ID = UUID.fromString("e333ec57-548d-41a1-aa4a-05bce4cfd028");
    public static final String RADIO_NAME = "Radio";
    public static final String ID_TAG = "id";
    public static final String STREAM_URL_TAG = "stream_url";
    public static final String STATION_NAME_TAG = "station_name";
    public static final String ON_TAG = "on";
    public static final String RANGE_TAG = "range";
    private final UUID id;
    private String url;
    private String stationName;
    private boolean on;
    private float range;

    public RadioData(UUID id, String url, String stationName, boolean on, float range) {
        this.id = id;
        this.url = url;
        this.stationName = stationName;
        this.on = on;
        this.range = range;
    }

    public RadioData(UUID id) {
        this.id = id;
        this.range = -1.0f;
    }

    public UUID getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getStationName() {
        return this.stationName;
    }

    public boolean isOn() {
        return this.on;
    }

    public float getRange() {
        return this.range;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public void setRange(float range) {
        this.range = range;
    }

    @Nullable
    public static RadioData fromGameProfile(GameProfile gameProfile) {
        if (!RadioData.isRadio(gameProfile)) {
            return null;
        }
        UUID uuid = UUID.randomUUID();
        String value = RadioData.getValue(gameProfile, ID_TAG);
        if (value != null) {
            try {
                uuid = UUID.fromString(value);
            }
            catch (Exception e) {
                Radio.LOGGER.warn("Failed to parse UUID '{}'", (Object)value, (Object)e);
            }
        }
        RadioData radioData = new RadioData(uuid);
        radioData.url = RadioData.getValue(gameProfile, STREAM_URL_TAG);
        radioData.stationName = RadioData.getValue(gameProfile, STATION_NAME_TAG);
        radioData.on = Boolean.parseBoolean(RadioData.getValue(gameProfile, ON_TAG));
        radioData.range = RadioData.getFloatValueOrElse(gameProfile, RANGE_TAG, -1.0f);
        return radioData;
    }

    public GameProfile toGameProfile() {
        GameProfile gameProfile = HeadUtils.getGameProfile(RADIO_ID, RADIO_NAME, Radio.SERVER_CONFIG.radioSkinUrl.get());
        this.updateProfile(gameProfile);
        return gameProfile;
    }

    public void updateProfile(GameProfile gameProfile) {
        if (this.id.equals(class_156.field_25140)) {
            RadioData.removeValue(gameProfile, ID_TAG);
        } else {
            RadioData.putValue(gameProfile, ID_TAG, this.id.toString());
        }
        RadioData.putValue(gameProfile, STREAM_URL_TAG, this.url);
        RadioData.putValue(gameProfile, STATION_NAME_TAG, this.stationName);
        RadioData.putValue(gameProfile, ON_TAG, String.valueOf(this.on));
        RadioData.putValue(gameProfile, RANGE_TAG, String.valueOf(this.range));
    }

    @Nullable
    private static String getValue(GameProfile gameProfile, String key) {
        return gameProfile.getProperties().get((Object)key).stream().map(Property::getValue).findFirst().orElse(null);
    }

    private static float getFloatValueOrElse(GameProfile gameProfile, String key, float orElse) {
        String value = RadioData.getValue(gameProfile, key);
        if (value == null) {
            return orElse;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException err) {
            Radio.LOGGER.warn("Malformed radio data: %s".formatted(err.getMessage()));
            return orElse;
        }
    }

    private static void putValue(GameProfile gameProfile, String key, String value) {
        PropertyMap properties = gameProfile.getProperties();
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(new Property(key, value));
        properties.replaceValues((Object)key, props);
    }

    private static void removeValue(GameProfile gameProfile, String key) {
        PropertyMap properties = gameProfile.getProperties();
        properties.replaceValues((Object)key, new ArrayList());
    }

    private static class_1799 createRadio(RadioData radioData) {
        return HeadUtils.createHead(RADIO_NAME, Collections.singletonList(class_2561.method_43470((String)radioData.stationName).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080)), radioData.toGameProfile());
    }

    public class_1799 toItemWithNoId() {
        RadioData radioData = new RadioData(class_156.field_25140, this.url, this.stationName, false, this.range);
        return RadioData.createRadio(radioData);
    }

    public static boolean isRadio(GameProfile profile) {
        if (profile == null) {
            return false;
        }
        return profile.getId().equals(RADIO_ID);
    }
}

