/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.radio.Radio;
import de.maxhenkel.radio.radio.RadioData;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class RadioCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 environment) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"radio").requires(commandSource -> commandSource.method_9259(Radio.SERVER_CONFIG.commandPermissionLevel.get().intValue()));
        literalBuilder.then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"station_name", (ArgumentType)StringArgumentType.string()).executes(RadioCommands::runWithoutRange)).then(class_2170.method_9244((String)"sound_radius", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(RadioCommands::runWithRange)))));
        dispatcher.register(literalBuilder);
    }

    private static int runWithRange(CommandContext<class_2168> context) throws CommandSyntaxException {
        String url = StringArgumentType.getString(context, (String)"url");
        String stationName = StringArgumentType.getString(context, (String)"station_name");
        float soundRadius = FloatArgumentType.getFloat(context, (String)"sound_radius");
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return RadioCommands.runCommand(url, stationName, player, soundRadius);
    }

    private static int runWithoutRange(CommandContext<class_2168> context) throws CommandSyntaxException {
        String url = StringArgumentType.getString(context, (String)"url");
        String stationName = StringArgumentType.getString(context, (String)"station_name");
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return RadioCommands.runCommand(url, stationName, player, -1.0f);
    }

    private static int runCommand(String url, String stationName, class_3222 player, float range) {
        RadioData radioData = new RadioData(UUID.randomUUID(), url, stationName, false, range);
        player.method_31548().method_7394(radioData.toItemWithNoId());
        return 1;
    }
}

