/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.ExtraModels;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1087;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix4f;

public class ElectricBlockEntityRenderer<T extends class_2586>
implements class_827<T> {
    private static final Set<Connection> DRAWN_CONNECTIONS = new HashSet<Connection>();
    private static final int DEFAULT_COLOUR = -1;
    private static final int POWERED_COLOUR = -9652;
    private static final int CROSSING_ZONE_COLOUR = -3983818;
    private static final float POWER_NODE_SCALE = 1.5f;

    public ElectricBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void method_3569(T node, float partialTick, class_4587 poseStack, class_4597 source, int light, int overlay) {
        ElectricBlockEntityRenderer.drawNodeAndConnections((IElectricityNode)node);
    }

    public static void drawNodeAndConnections(IElectricityNode node) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || !LinkHandler.isHoldingWrench()) {
            return;
        }
        DeferredElectricRenderer renderer = DeferredElectricRenderer.get();
        LinkHandler handler = LinkHandler.get();
        boolean isLookingAt = handler.isTargetNode(node);
        if (isLookingAt && !handler.isLinking() && !node.isNodeConnectionLimitReached() || handler.isLinkingNode(node) || handler.canLinkToNode(node.getNodeLevel(), node) && handler.isTargetNode(node)) {
            class_238 box = node.getNodeInteractBox();
            int color = handler.getLinkColour(node.getNodeLevel());
            renderer.deferDraw((pose, consumer) -> {
                pose.method_22903();
                class_2338 pos = node.getNodePosition();
                pose.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                Matrix4f matrix = pose.method_23760().method_23761();
                renderer.drawInvertedColouredBox(matrix, (class_4588)consumer, box.method_1014(0.03125), color, 0.7f);
                pose.method_22909();
            });
        }
        for (Connection connection : node.getNodeConnections()) {
            if (DRAWN_CONNECTIONS.contains(connection)) continue;
            DRAWN_CONNECTIONS.add(connection);
            renderer.deferDraw((pose, consumer) -> {
                pose.method_22903();
                class_2338 pos = node.getNodePosition();
                pose.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                pose.method_22904(0.5, 0.5, 0.5);
                class_243 delta = class_243.method_24954((class_2382)connection.getPosB().method_10059((class_2382)connection.getPosA()));
                double yaw = Math.atan2(-delta.field_1350, delta.field_1352) + Math.PI;
                double pitch = Math.atan2(delta.method_37267(), delta.field_1351) + 1.5707963705062866;
                boolean selected = !handler.isLinking() && connection.equals(handler.getTargetConnection());
                int color = ElectricBlockEntityRenderer.getConnectionColour(connection, node.getNodeLevel());
                float offset = (float)(Math.sin((double)class_156.method_658() / 500.0) + 1.0) / 2.0f * 0.2f;
                class_238 box = new class_238(0.0, -0.03125, -0.03125, delta.method_1033(), 0.03125, 0.03125);
                pose.method_22907(class_7833.field_40716.rotation((float)yaw));
                pose.method_22907(class_7833.field_40718.rotation((float)pitch));
                Matrix4f matrix = pose.method_23760().method_23761();
                renderer.drawColouredBox(matrix, (class_4588)consumer, box, color, 0.7f + offset);
                renderer.drawColouredBox(matrix, (class_4588)consumer, box.method_1014(0.03125), color, 0.5f + offset);
                if (selected) {
                    renderer.drawColouredBox(matrix, (class_4588)consumer, box.method_1014(0.03125), -1, 0.8f);
                }
                pose.method_22909();
            });
        }
        renderer.deferDraw((pose, consumer) -> {
            pose.method_22903();
            class_2338 pos = node.getNodePosition();
            pose.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            Matrix4f matrix = pose.method_23760().method_23761();
            renderer.drawTexturedBox(matrix, (class_4588)consumer, node.getNodeInteractBox(), 0.0f, 0.0f, 0.25f, 0.25f);
            pose.method_22909();
        });
    }

    private static int getConnectionColour(Connection connection, class_1937 level) {
        if (connection.isCrossingPowerableZone(level)) {
            return -3983818;
        }
        if (connection.isPowered(level)) {
            return -9652;
        }
        return -1;
    }

    private static class_1087 getNodeModel(IElectricityNode node) {
        if (node.isNodeConnectionLimitReached()) {
            return ExtraModels.ELECTRIC_NODE_ERROR.getModel();
        }
        LinkHandler handler = LinkHandler.get();
        if (handler.isLinking() && !handler.isLinkingNode(node)) {
            if (handler.canLinkToNode(node.getNodeLevel(), node)) {
                return ExtraModels.ELECTRIC_NODE_SUCCESS.getModel();
            }
            return ExtraModels.ELECTRIC_NODE_ERROR.getModel();
        }
        if (node.isNodePowered()) {
            return ExtraModels.ELECTRIC_NODE_NEUTRAL.getModel();
        }
        return ExtraModels.ELECTRIC_NODE_POWER.getModel();
    }

    public boolean method_3563(T node) {
        return true;
    }

    public int method_33893() {
        return (Integer)Config.CLIENT.electricityViewDistance.get();
    }

    public static void clearDrawn() {
        DRAWN_CONNECTIONS.clear();
    }

    public static Set<Connection> getDrawnConnections() {
        return DRAWN_CONNECTIONS;
    }
}

