/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.StoveBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.data.DropWithName;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class StoveBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier,
class_3954,
DropWithName {
    private final MetalType type;

    public StoveBlock(MetalType type, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public MetalType getMetalType() {
        return this.type;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 topShape = class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 baseShape = class_2248.method_9541((double)2.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        class_265 bottomShape = class_2248.method_9541((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        class_265 closedDoorShape = class_2248.method_9541((double)0.0, (double)1.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0);
        class_265 openDoorShape = class_2248.method_9541((double)-11.0, (double)1.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            boolean open = (Boolean)state.method_11654((class_2769)OPEN);
            class_2350 direction = (class_2350)state.method_11654((class_2769)DIRECTION);
            ArrayList<class_265> shapes = new ArrayList<class_265>(List.of(topShape));
            shapes.add(VoxelShapeHelper.rotateHorizontally(baseShape, direction));
            shapes.add(VoxelShapeHelper.rotateHorizontally(bottomShape, direction));
            shapes.add(VoxelShapeHelper.rotateHorizontally(open ? openDoorShape : closedDoorShape, direction));
            return VoxelShapeHelper.combine(shapes);
        })));
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        if (((class_2350)state.method_11654((class_2769)DIRECTION)).method_10153() == result.method_17780()) {
            class_2586 class_25862;
            if (!level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof StoveBlockEntity) {
                StoveBlockEntity stove = (StoveBlockEntity)class_25862;
                player.method_17355((class_3908)stove);
                return class_1269.field_21466;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 class_25862;
        if (!state.method_27852(newState.method_26204()) && (class_25862 = level.method_8321(pos)) instanceof StoveBlockEntity) {
            StoveBlockEntity stove = (StoveBlockEntity)class_25862;
            stove.onDestroyed(pos);
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 neighbourPos, boolean movedByPiston) {
        class_2586 class_25862;
        super.method_9612(state, level, pos, block, neighbourPos, movedByPiston);
        if (pos.method_10084().equals((Object)neighbourPos) && (class_25862 = level.method_8321(pos)) instanceof StoveBlockEntity) {
            StoveBlockEntity stove = (StoveBlockEntity)class_25862;
            stove.onNeighbourChanged();
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{OPEN});
        builder.method_11667(new class_2769[]{POWERED});
        builder.method_11667(new class_2769[]{LIT});
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        class_2586 class_25862;
        if (stack.method_7938() && (class_25862 = level.method_8321(pos)) instanceof StoveBlockEntity) {
            StoveBlockEntity stove = (StoveBlockEntity)class_25862;
            stove.method_17488(stack.method_7964());
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return Services.BLOCK_ENTITY.createStoveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (!level.method_8608()) {
            return StoveBlock.createTicker(type, (class_2591)ModBlockEntities.STOVE.get(), StoveBlockEntity::serverTick);
        }
        return null;
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity = (BasicLootBlockEntity)class_25862;
            blockEntity.updateOpenerCount();
        }
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33715, class_3481.field_33719);
    }

    public class_1278 method_17680(class_2680 state, class_1936 accessor, class_2338 pos) {
        class_2586 class_25862 = accessor.method_8321(pos);
        if (class_25862 instanceof StoveBlockEntity) {
            StoveBlockEntity stove = (StoveBlockEntity)class_25862;
            return stove.getContainer();
        }
        return null;
    }
}

