/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.util;

import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.Config;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.exceptions.ConfigCreationException;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.util.ImmutableIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigsImpl {
    private static final Map<String, Map<String, Config>> CONFIGS = new TreeMap<String, Map<String, Config>>();

    private ConfigsImpl() {
    }

    public static void put(String familyId, Config config) {
        if (CONFIGS.containsKey(familyId) && CONFIGS.get(familyId).containsKey(config.id())) {
            throw new ConfigCreationException("Config '" + familyId + ':' + config.id() + "' already exists");
        }
        CONFIGS.computeIfAbsent(familyId, id2 -> new TreeMap()).put(config.id(), config);
    }

    public static Iterable<Config> getAll() {
        return ConfigsImpl::itr;
    }

    public static Iterable<Config> getConfigs(String familyId) {
        return new ImmutableIterable<Config>(CONFIGS.getOrDefault(familyId, Collections.emptyMap()).values());
    }

    @Nullable
    public static Config getConfig(String familyId, String configId) {
        return (Config)CONFIGS.getOrDefault(familyId, Collections.emptyMap()).get(configId);
    }

    @NotNull
    private static Iterator<Config> itr() {
        return new AllConfigsIterator();
    }

    static /* synthetic */ Map access$100() {
        return CONFIGS;
    }

    private static class AllConfigsIterator
    implements Iterator<Config> {
        final Iterator<Map<String, Config>> itr1 = ConfigsImpl.access$100().values().iterator();
        Iterator<Config> itr2 = this.itr1.hasNext() ? this.itr1.next().values().iterator() : Collections.emptyIterator();

        private AllConfigsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.itr1.hasNext() || this.itr2.hasNext();
        }

        @Override
        public Config next() {
            while (!this.itr2.hasNext() && this.itr1.hasNext()) {
                this.itr2 = this.itr1.next().values().iterator();
            }
            return this.itr2.next();
        }
    }
}

