/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.annotations;

import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.Constraint;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.annotations.ConfigFieldAnnotationProcessor;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.exceptions.ConfigFieldException;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.metadata.MetadataContainerBuilder;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.values.CompoundConfigValue;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.values.TrackedValue;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface IntegerRange {
    public long min();

    public long max();

    public static final class Processor
    implements ConfigFieldAnnotationProcessor<IntegerRange> {
        @Override
        public void process(IntegerRange range, MetadataContainerBuilder<?> builder) {
            if (builder instanceof TrackedValue.Builder) {
                Object defaultValue = ((TrackedValue.Builder)builder).getDefaultValue();
                if (defaultValue instanceof Integer) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.range((int)range.min(), (int)range.max()));
                } else if (defaultValue instanceof Long) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.range(range.min(), range.max()));
                } else if (defaultValue instanceof CompoundConfigValue && Integer.class.isAssignableFrom(((CompoundConfigValue)defaultValue).getType())) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.all(Constraint.range((int)range.min(), (int)range.max())));
                } else if (defaultValue instanceof CompoundConfigValue && Long.class.isAssignableFrom(((CompoundConfigValue)defaultValue).getType())) {
                    ((TrackedValue.Builder)builder).constraint(Constraint.all(Constraint.range(range.min(), range.max())));
                } else {
                    throw new ConfigFieldException("Constraint LongRange not applicable for type '" + defaultValue.getClass() + "'");
                }
            }
        }
    }
}

