/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.annotations;

import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.annotations.Comment;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.annotations.ConfigFieldAnnotationProcessor;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.annotations.FloatRange;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.annotations.IntegerRange;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.annotations.Matches;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.metadata.MetadataContainerBuilder;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.Comments;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

public final class ConfigFieldAnnotationProcessors {
    private static final Map<Class<? extends Annotation>, List<ConfigFieldAnnotationProcessor<?>>> PROCESSORS = new HashMap();

    public static <T extends Annotation> void register(Class<T> annotationClass, ConfigFieldAnnotationProcessor<T> processor) {
        PROCESSORS.computeIfAbsent(annotationClass, c -> new ArrayList()).add(processor);
    }

    private static <T extends Annotation> void process(ConfigFieldAnnotationProcessor<T> processor, T annotation, MetadataContainerBuilder<?> builder) {
        processor.process(annotation, builder);
    }

    @ApiStatus.Internal
    public static void applyAnnotationProcessors(Annotation annotation, MetadataContainerBuilder<?> builder) {
        for (ConfigFieldAnnotationProcessor processor : PROCESSORS.getOrDefault(annotation.annotationType(), Collections.emptyList())) {
            ConfigFieldAnnotationProcessors.process(processor, annotation, builder);
        }
    }

    static {
        ConfigFieldAnnotationProcessors.register(Comment.class, new Comment.Processor());
        ConfigFieldAnnotationProcessors.register(Comments.class, new Comments.Processor());
        ConfigFieldAnnotationProcessors.register(IntegerRange.class, new IntegerRange.Processor());
        ConfigFieldAnnotationProcessors.register(FloatRange.class, new FloatRange.Processor());
        ConfigFieldAnnotationProcessors.register(Matches.class, new Matches.Processor());
    }
}

