/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.wiredredstone.part;

import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.event.PartRedstonePowerEvent;
import alexiil.mc.lib.multipart.api.event.PartTickEvent;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import com.kneelawk.wiredredstone.logic.RedstoneLogic;
import com.kneelawk.wiredredstone.part.AbstractGatePart;
import com.kneelawk.wiredredstone.util.PartExtensionsKt;
import com.kneelawk.wiredredstone.util.RotationUtils;
import com.kneelawk.wiredredstone.util.WorldUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001BL\b\u0016\u0012\u0006\u00105\u001a\u000204\u0012\u0006\u00107\u001a\u000206\u0012\u0006\u00108\u001a\u00020\u0006\u0012\u0006\u0010:\u001a\u000209\u0012\u0006\u0010;\u001a\u00020\u0006\u0012\u0006\u0010,\u001a\u00020\u0002\u0012\u0006\u0010/\u001a\u00020\u0002\u0012\u0006\u00102\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b<\u0010=B!\b\u0016\u0012\u0006\u00105\u001a\u000204\u0012\u0006\u00107\u001a\u000206\u0012\u0006\u0010>\u001a\u00020 \u00a2\u0006\u0004\b<\u0010?B)\b\u0016\u0012\u0006\u00105\u001a\u000204\u0012\u0006\u00107\u001a\u000206\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b<\u0010@J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u0004J\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0010H&\u00a2\u0006\u0004\b\u001b\u0010\u0014J\u000f\u0010\u001d\u001a\u00020\u001cH&\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u000f\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b&\u0010%J\u001f\u0010(\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020'H\u0016\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010*\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020'H\u0016\u00a2\u0006\u0004\b*\u0010)R$\u0010,\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010\u0004R*\u0010/\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00028\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010-\u001a\u0004\b0\u0010\u0004\"\u0004\b1\u0010%R$\u00102\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b2\u0010-\u001a\u0004\b3\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Lcom/kneelawk/wiredredstone/part/AbstractInputOutputGatePart;", "Lcom/kneelawk/wiredredstone/part/AbstractGatePart;", "", "calculateInputPower", "()I", "calculateOutputReversePower", "Lnet/minecraft/class_2350;", "getInputSide", "()Lnet/minecraft/class_2350;", "getOutputSide", "powerSide", "getRedstoneOutputPower", "(Lnet/minecraft/class_2350;)I", "getTotalOutputPower", "Lalexiil/mc/lib/multipart/api/MultipartEventBus;", "bus", "", "onAdded", "(Lalexiil/mc/lib/multipart/api/MultipartEventBus;)V", "onRemoved", "()V", "Lalexiil/mc/lib/net/NetByteBuf;", "buffer", "Lalexiil/mc/lib/net/IMsgReadCtx;", "ctx", "readRenderData", "(Lalexiil/mc/lib/net/NetByteBuf;Lalexiil/mc/lib/net/IMsgReadCtx;)V", "recalculate", "", "shouldRecalculate", "()Z", "shouldScheduleUpdate", "Lnet/minecraft/class_2487;", "toTag", "()Lnet/minecraft/class_2487;", "power", "updateInputPower", "(I)V", "updateOutputReversePower", "Lalexiil/mc/lib/net/IMsgWriteCtx;", "writeCreationData", "(Lalexiil/mc/lib/net/NetByteBuf;Lalexiil/mc/lib/net/IMsgWriteCtx;)V", "writeRenderData", "<set-?>", "inputPower", "I", "getInputPower", "outputPower", "getOutputPower", "setOutputPower", "outputReversePower", "getOutputReversePower", "Lalexiil/mc/lib/multipart/api/PartDefinition;", "definition", "Lalexiil/mc/lib/multipart/api/MultipartHolder;", "holder", "side", "Lkotlin/UByte;", "connections", "direction", "<init>", "(Lalexiil/mc/lib/multipart/api/PartDefinition;Lalexiil/mc/lib/multipart/api/MultipartHolder;Lnet/minecraft/class_2350;BLnet/minecraft/class_2350;IIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "tag", "(Lalexiil/mc/lib/multipart/api/PartDefinition;Lalexiil/mc/lib/multipart/api/MultipartHolder;Lnet/minecraft/class_2487;)V", "(Lalexiil/mc/lib/multipart/api/PartDefinition;Lalexiil/mc/lib/multipart/api/MultipartHolder;Lalexiil/mc/lib/net/NetByteBuf;Lalexiil/mc/lib/net/IMsgReadCtx;)V", "wired-redstone"})
public abstract class AbstractInputOutputGatePart
extends AbstractGatePart {
    private int inputPower;
    private int outputPower;
    private int outputReversePower;

    public final int getInputPower() {
        return this.inputPower;
    }

    public final int getOutputPower() {
        return this.outputPower;
    }

    protected final void setOutputPower(int n) {
        this.outputPower = n;
    }

    public final int getOutputReversePower() {
        return this.outputReversePower;
    }

    private AbstractInputOutputGatePart(PartDefinition definition, MultipartHolder holder, class_2350 side, byte connections2, class_2350 direction, int inputPower, int outputPower, int outputReversePower) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        super(definition, holder, side, connections2, direction, null);
        this.inputPower = inputPower;
        this.outputPower = outputPower;
        this.outputReversePower = outputReversePower;
    }

    public AbstractInputOutputGatePart(@NotNull PartDefinition definition, @NotNull MultipartHolder holder, @NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super(definition, holder, tag);
        this.inputPower = RangesKt.coerceIn((int)tag.method_10571("inputPower"), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
        this.outputPower = RangesKt.coerceIn((int)tag.method_10571("outputPower"), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
        this.outputReversePower = RangesKt.coerceIn((int)tag.method_10571("outputReversePower"), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
    }

    public AbstractInputOutputGatePart(@NotNull PartDefinition definition, @NotNull MultipartHolder holder, @NotNull NetByteBuf buffer, @NotNull IMsgReadCtx ctx) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(definition, holder, buffer, ctx);
        this.inputPower = RangesKt.coerceIn((int)buffer.readFixedBits(4), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
        this.outputPower = RangesKt.coerceIn((int)buffer.readFixedBits(4), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
        this.outputReversePower = RangesKt.coerceIn((int)buffer.readFixedBits(4), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
    }

    public abstract boolean shouldRecalculate();

    public abstract void recalculate();

    @Override
    @NotNull
    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        tag.method_10567("inputPower", (byte)this.inputPower);
        tag.method_10567("outputPower", (byte)this.outputPower);
        tag.method_10567("outputReversePower", (byte)this.outputReversePower);
        return tag;
    }

    @Override
    public void writeCreationData(@NotNull NetByteBuf buffer, @NotNull IMsgWriteCtx ctx) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super.writeCreationData(buffer, ctx);
        buffer.writeFixedBits(this.inputPower, 4);
        buffer.writeFixedBits(this.outputPower, 4);
        buffer.writeFixedBits(this.outputReversePower, 4);
    }

    @Override
    public void writeRenderData(@NotNull NetByteBuf buffer, @NotNull IMsgWriteCtx ctx) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super.writeRenderData(buffer, ctx);
        buffer.writeFixedBits(this.inputPower, 4);
        buffer.writeFixedBits(this.outputPower, 4);
        buffer.writeFixedBits(this.outputReversePower, 4);
    }

    @Override
    public void readRenderData(@NotNull NetByteBuf buffer, @NotNull IMsgReadCtx ctx) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super.readRenderData(buffer, ctx);
        this.inputPower = RangesKt.coerceIn((int)buffer.readFixedBits(4), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
        this.outputPower = RangesKt.coerceIn((int)buffer.readFixedBits(4), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
        this.outputReversePower = RangesKt.coerceIn((int)buffer.readFixedBits(4), (ClosedRange)((ClosedRange)new IntRange(0, 15)));
    }

    @Override
    public void onAdded(@NotNull MultipartEventBus bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        super.onAdded(bus);
        bus.addListener((Object)this, PartTickEvent.class, arg_0 -> AbstractInputOutputGatePart.onAdded$lambda$0(this, arg_0));
        bus.addListener((Object)this, PartRedstonePowerEvent.class, arg_0 -> AbstractInputOutputGatePart.onAdded$lambda$1(this, arg_0));
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (!PartExtensionsKt.isClientSide(this)) {
            class_2350 edge = RotationUtils.INSTANCE.rotatedDirection(this.getSide(), this.getDirection());
            WorldUtils.INSTANCE.strongUpdateOutputNeighbors(PartExtensionsKt.getWorld(this), this.getPos(), edge);
        }
    }

    private final int getRedstoneOutputPower(class_2350 powerSide) {
        class_2350 edge = RotationUtils.INSTANCE.rotatedDirection(this.getSide(), this.getDirection());
        return RedstoneLogic.INSTANCE.getWiresGivePower() && powerSide == edge ? this.outputPower : 0;
    }

    @Override
    public boolean shouldScheduleUpdate() {
        return this.calculateInputPower() != this.inputPower || this.calculateOutputReversePower() != this.outputReversePower;
    }

    public final int getTotalOutputPower() {
        return Math.max(this.outputPower, this.outputReversePower);
    }

    public final int calculateInputPower() {
        class_2350 edge = RotationUtils.INSTANCE.rotatedDirection(this.getSide(), this.getInputSide());
        return PartExtensionsKt.getWorld(this).method_49808(this.getPos().method_10093(edge), edge);
    }

    public final int calculateOutputReversePower() {
        class_2350 edge = RotationUtils.INSTANCE.rotatedDirection(this.getSide(), this.getOutputSide());
        return PartExtensionsKt.getWorld(this).method_49808(this.getPos().method_10093(edge), edge);
    }

    @NotNull
    public final class_2350 getInputSide() {
        class_2350 class_23502 = this.getDirection().method_10153();
        Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"direction.opposite");
        return class_23502;
    }

    @NotNull
    public final class_2350 getOutputSide() {
        return this.getDirection();
    }

    public void updateOutputReversePower(int power) {
        boolean changed = this.outputReversePower != power;
        this.outputReversePower = power;
        if (changed) {
            this.redraw();
            PartExtensionsKt.getBlockEntity(this).method_5431();
        }
    }

    public void updateInputPower(int power) {
        boolean changed = this.inputPower != power;
        this.inputPower = power;
        if (changed) {
            this.redraw();
            PartExtensionsKt.getBlockEntity(this).method_5431();
        }
    }

    private static final void onAdded$lambda$0(AbstractInputOutputGatePart this$0, PartTickEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        class_1937 world = PartExtensionsKt.getWorld(this$0);
        if (world instanceof class_3218 && this$0.shouldRecalculate()) {
            this$0.recalculate();
            class_2338 pos = this$0.getPos();
            RedstoneLogic.INSTANCE.scheduleUpdate((class_3218)world, pos);
            this$0.redraw();
            class_2350 edge = RotationUtils.INSTANCE.rotatedDirection(this$0.getSide(), this$0.getDirection());
            WorldUtils.INSTANCE.strongUpdateOutputNeighbors(world, pos, edge);
        }
    }

    private static final void onAdded$lambda$1(AbstractInputOutputGatePart this$0, PartRedstonePowerEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        class_2350 class_23502 = e.side;
        Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"e.side");
        e.set(this$0.getRedstoneOutputPower(class_23502));
    }

    public /* synthetic */ AbstractInputOutputGatePart(PartDefinition definition, MultipartHolder holder, class_2350 side, byte connections2, class_2350 direction, int inputPower, int outputPower, int outputReversePower, DefaultConstructorMarker $constructor_marker) {
        this(definition, holder, side, connections2, direction, inputPower, outputPower, outputReversePower);
    }
}

