/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.batchedentityrendering.impl;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.irisshaders.batchedentityrendering.impl.BlendingStateHolder;
import net.irisshaders.batchedentityrendering.impl.BufferBuilderExt;
import net.irisshaders.batchedentityrendering.impl.BufferSegment;
import net.irisshaders.batchedentityrendering.impl.MemoryTrackingBuffer;
import net.irisshaders.batchedentityrendering.impl.RenderTypeUtil;
import net.irisshaders.batchedentityrendering.impl.TransparencyType;
import net.irisshaders.batchedentityrendering.mixin.RenderTypeAccessor;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class SegmentedBufferBuilder
implements class_4597,
MemoryTrackingBuffer {
    private final class_287 buffer = new class_287(524288);
    private final List<BufferSegment> buffers = new ArrayList<BufferSegment>();
    private class_1921 currentType = null;

    private static boolean shouldSortOnUpload(class_1921 type) {
        return ((RenderTypeAccessor)type).shouldSortOnUpload();
    }

    public class_4588 getBuffer(class_1921 renderType) {
        if (!Objects.equals(this.currentType, renderType)) {
            if (this.currentType != null) {
                if (SegmentedBufferBuilder.shouldSortOnUpload(this.currentType)) {
                    this.buffer.method_49904(RenderSystem.getVertexSorting());
                }
                this.buffers.add(new BufferSegment(Objects.requireNonNull(this.buffer.method_1326()), this.currentType));
            }
            this.buffer.method_1328(renderType.method_23033(), renderType.method_23031());
            this.currentType = renderType;
        }
        if (RenderTypeUtil.isTriangleStripDrawMode(this.currentType)) {
            ((BufferBuilderExt)this.buffer).splitStrip();
        }
        return this.buffer;
    }

    public List<BufferSegment> getSegments() {
        if (this.currentType == null) {
            return Collections.emptyList();
        }
        if (SegmentedBufferBuilder.shouldSortOnUpload(this.currentType)) {
            this.buffer.method_49904(RenderSystem.getVertexSorting());
        }
        this.buffers.add(new BufferSegment(Objects.requireNonNull(this.buffer.method_1326()), this.currentType));
        this.currentType = null;
        ArrayList<BufferSegment> finalSegments = new ArrayList<BufferSegment>(this.buffers);
        this.buffers.clear();
        return finalSegments;
    }

    public List<BufferSegment> getSegmentsForType(TransparencyType transparencyType) {
        if (this.currentType == null) {
            return Collections.emptyList();
        }
        if (((BlendingStateHolder)this.currentType).getTransparencyType() == transparencyType) {
            if (SegmentedBufferBuilder.shouldSortOnUpload(this.currentType)) {
                this.buffer.method_49904(RenderSystem.getVertexSorting());
            }
            this.buffers.add(new BufferSegment(Objects.requireNonNull(this.buffer.method_1326()), this.currentType));
            this.currentType = null;
        }
        List<BufferSegment> finalSegments = this.buffers.stream().filter(segment -> ((BlendingStateHolder)segment.type()).getTransparencyType() == transparencyType).toList();
        this.buffers.removeAll(finalSegments);
        return finalSegments;
    }

    @Override
    public int getAllocatedSize() {
        return ((MemoryTrackingBuffer)this.buffer).getAllocatedSize();
    }

    @Override
    public int getUsedSize() {
        return ((MemoryTrackingBuffer)this.buffer).getUsedSize();
    }

    @Override
    public void freeAndDeleteBuffer() {
        ((MemoryTrackingBuffer)this.buffer).freeAndDeleteBuffer();
    }
}

